/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.throttle.databridge.publisher;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.DataProcessAndPublishingAgent;
import org.wso2.micro.gateway.enforcer.throttle.databridge.publisher.PublisherConfiguration;

public class ThrottleDataPublisherPool {
    private static final Logger log = LogManager.getLogger(ThrottleDataPublisherPool.class);
    private ObjectPool clientPool;

    private ThrottleDataPublisherPool() {
        PublisherConfiguration configuration = PublisherConfiguration.getInstance();
        this.clientPool = new StackObjectPool(new BasePoolableObjectFactory(){

            @Override
            public Object makeObject() throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("Initializing new ThrottleDataPublisher instance");
                }
                return new DataProcessAndPublishingAgent();
            }
        }, configuration.getMaxIdleDataPublishingAgents(), configuration.getInitIdleObjectDataPublishingAgents());
    }

    public static ThrottleDataPublisherPool getInstance() {
        return ThrottleDataPublisherPoolHolder.INSTANCE;
    }

    public DataProcessAndPublishingAgent get() throws Exception {
        return (DataProcessAndPublishingAgent)this.clientPool.borrowObject();
    }

    public void release(DataProcessAndPublishingAgent client) throws Exception {
        client.clearDataReference();
        this.clientPool.returnObject(client);
    }

    public void cleanup() {
        try {
            this.clientPool.close();
        }
        catch (Exception e) {
            log.warn("Error while cleaning up the object pool", (Throwable)e);
        }
    }

    private static class ThrottleDataPublisherPoolHolder {
        private static final ThrottleDataPublisherPool INSTANCE = new ThrottleDataPublisherPool();

        private ThrottleDataPublisherPoolHolder() {
        }
    }
}

