/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.enforcer.util;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.nio.file.Paths;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.enforcer.config.ConfigHolder;

public class GRPCUtils {
    public static ManagedChannel createSecuredChannel(Logger logger, String host, int port) {
        File certFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPublicKeyPath(), new String[0]).toFile();
        File keyFile = Paths.get(ConfigHolder.getInstance().getEnvVarConfig().getEnforcerPrivateKeyPath(), new String[0]).toFile();
        SslContext sslContext = null;
        try {
            sslContext = GrpcSslContexts.forClient().trustManager(ConfigHolder.getInstance().getTrustManagerFactory()).keyManager(certFile, keyFile).build();
        }
        catch (SSLException e) {
            logger.error("Error while generating SSL Context.", (Throwable)e);
        }
        return ((NettyChannelBuilder)NettyChannelBuilder.forAddress(host, port).useTransportSecurity().sslContext(sslContext).overrideAuthority(ConfigHolder.getInstance().getEnvVarConfig().getAdapterHostName())).build();
    }
}

