/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wso2.org.apache.mina.common.IoFilter;
import org.wso2.org.apache.mina.common.IoFilterChain;
import org.wso2.org.apache.mina.common.IoFilterChainBuilder;

public class DefaultIoFilterChainBuilder
implements IoFilterChainBuilder,
Cloneable {
    private final List<IoFilterChain.Entry> entries = new CopyOnWriteArrayList<IoFilterChain.Entry>();

    public IoFilterChain.Entry getEntry(String name) {
        for (IoFilterChain.Entry e : this.entries) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public IoFilter get(String name) {
        IoFilterChain.Entry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        return e.getFilter();
    }

    public List<IoFilterChain.Entry> getAll() {
        return new ArrayList<IoFilterChain.Entry>(this.entries);
    }

    public List<IoFilterChain.Entry> getAllReversed() {
        List<IoFilterChain.Entry> result = this.getAll();
        Collections.reverse(result);
        return result;
    }

    public boolean contains(String name) {
        return this.getEntry(name) != null;
    }

    public boolean contains(IoFilter filter) {
        for (IoFilterChain.Entry e : this.entries) {
            if (e.getFilter() != filter) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<? extends IoFilter> filterType) {
        for (IoFilterChain.Entry e : this.entries) {
            if (!filterType.isAssignableFrom(e.getFilter().getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addFirst(String name, IoFilter filter) {
        this.register(0, new EntryImpl(name, filter));
    }

    public synchronized void addLast(String name, IoFilter filter) {
        this.register(this.entries.size(), new EntryImpl(name, filter));
    }

    public synchronized void addBefore(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ListIterator<IoFilterChain.Entry> i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.previousIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized void addAfter(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ListIterator<IoFilterChain.Entry> i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.nextIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized IoFilter remove(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ListIterator<IoFilterChain.Entry> i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = i.next();
            if (!e.getName().equals(name)) continue;
            this.entries.remove(i.previousIndex());
            return e.getFilter();
        }
        throw new IllegalArgumentException("Unknown filter name: " + name);
    }

    public synchronized void clear() throws Exception {
        this.entries.clear();
    }

    @Override
    public void buildFilterChain(IoFilterChain chain) throws Exception {
        for (IoFilterChain.Entry e : this.entries) {
            chain.addLast(e.getName(), e.getFilter());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        boolean empty = true;
        for (IoFilterChain.Entry e : this.entries) {
            if (!empty) {
                buf.append(", ");
            } else {
                empty = false;
            }
            buf.append('(');
            buf.append(e.getName());
            buf.append(':');
            buf.append(e.getFilter());
            buf.append(')');
        }
        if (empty) {
            buf.append("empty");
        }
        buf.append(" }");
        return buf.toString();
    }

    public Object clone() {
        DefaultIoFilterChainBuilder ret = new DefaultIoFilterChainBuilder();
        for (IoFilterChain.Entry e : this.entries) {
            ret.addLast(e.getName(), e.getFilter());
        }
        return ret;
    }

    private void checkBaseName(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName");
        }
        if (!this.contains(baseName)) {
            throw new IllegalArgumentException("Unknown filter name: " + baseName);
        }
    }

    private void register(int index, IoFilterChain.Entry e) {
        if (this.contains(e.getName())) {
            throw new IllegalArgumentException("Other filter is using the same name: " + e.getName());
        }
        this.entries.add(index, e);
    }

    private static class EntryImpl
    implements IoFilterChain.Entry {
        private final String name;
        private final IoFilter filter;

        private EntryImpl(String name, IoFilter filter) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            this.name = name;
            this.filter = filter;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IoFilter getFilter() {
            return this.filter;
        }

        @Override
        public IoFilter.NextFilter getNextFilter() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }
}

