/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.EncodingType;
import org.wso2.securevault.KeyStoreType;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.TrustKeyStoreInformation;
import org.wso2.securevault.secret.SecretInformation;

public final class CipherTool {
    private static final String SOURCE_IN_LINED = "source";
    private static final String SOURCE_FILE = "sourcefile";
    private static final String PASSPHRASE = "passphrase";
    private static final String KEY_STORE = "keystore";
    private static final String STORE_TYPE = "storetype";
    private static final String STORE_PASS = "storepass";
    private static final String KEY_PASS = "keypass";
    private static final String ALIAS = "alias";
    private static final String KEY_FILE = "keyfile";
    private static final String ALGORITHM = "algorithm";
    private static final String OP_MODE = "opmode";
    private static final String CIPHER_TYPE = "ciphertype";
    private static final String TARGET_FILE = "targetfile";
    private static final String OUT_TYPE = "outencode";
    private static final String IN_TYPE = "inencode";
    private static final String TRUSTED = "trusted";
    private static Log log = LogFactory.getLog(CipherTool.class);

    private CipherTool() {
    }

    private static String getArgument(CommandLine cmd, String argName, String defaultValue) {
        if (cmd == null) {
            CipherTool.handleException("CommandLine is null");
        }
        if (argName == null || "".equals(argName)) {
            if (log.isDebugEnabled()) {
                log.debug("Provided argument name is null. Returning null as value");
            }
            return defaultValue;
        }
        if (cmd.hasOption(argName)) {
            return cmd.getOptionValue(argName);
        }
        return defaultValue;
    }

    private static boolean isArgumentPresent(CommandLine cmd, String argName) {
        if (cmd == null) {
            CipherTool.handleException("CommandLine is null");
        }
        if (argName == null || "".equals(argName)) {
            if (log.isDebugEnabled()) {
                log.debug("Provided argument name is null. Returning null as value");
            }
            return false;
        }
        return cmd.hasOption(argName);
    }

    private static CipherInformation getCipherInformation(CommandLine cmd) {
        String encOutType;
        CipherInformation information = new CipherInformation();
        information.setAlgorithm(CipherTool.getArgument(cmd, ALGORITHM, "RSA"));
        information.setCipherOperationMode(CipherOperationMode.valueOf(CipherTool.getArgument(cmd, OP_MODE, CipherOperationMode.ENCRYPT.toString()).toUpperCase()));
        String encInType = CipherTool.getArgument(cmd, IN_TYPE, null);
        if (encInType != null) {
            information.setInType(EncodingType.valueOf(encInType.toUpperCase()));
        }
        if ((encOutType = CipherTool.getArgument(cmd, OUT_TYPE, null)) != null) {
            information.setOutType(EncodingType.valueOf(encOutType.toUpperCase()));
        }
        information.setType(CipherTool.getArgument(cmd, CIPHER_TYPE, null));
        return information;
    }

    private static IdentityKeyStoreInformation getIdentityKeyStoreInformation(CommandLine cmd) {
        IdentityKeyStoreInformation information = new IdentityKeyStoreInformation();
        String alias = CipherTool.getArgument(cmd, ALIAS, null);
        CipherTool.assertEmpty(alias, ALIAS);
        information.setAlias(alias);
        String keyStore = CipherTool.getArgument(cmd, KEY_STORE, null);
        CipherTool.assertEmpty(keyStore, KEY_STORE);
        information.setLocation(keyStore);
        information.setStoreType(CipherTool.getArgument(cmd, STORE_TYPE, KeyStoreType.JKS.toString()));
        String storePass = CipherTool.getArgument(cmd, STORE_PASS, null);
        CipherTool.assertEmpty(storePass, STORE_PASS);
        SecretInformation secretInformation = new SecretInformation();
        secretInformation.setAliasSecret(storePass);
        information.setKeyStorePasswordProvider(secretInformation);
        return information;
    }

    private static TrustKeyStoreInformation getTrustKeyStoreInformation(CommandLine cmd) {
        TrustKeyStoreInformation information = new TrustKeyStoreInformation();
        information.setAlias(CipherTool.getArgument(cmd, ALIAS, null));
        String keyStore = CipherTool.getArgument(cmd, KEY_STORE, null);
        CipherTool.assertEmpty(keyStore, KEY_STORE);
        information.setLocation(keyStore);
        information.setStoreType(CipherTool.getArgument(cmd, STORE_TYPE, KeyStoreType.JKS.toString()));
        String storePass = CipherTool.getArgument(cmd, STORE_PASS, null);
        CipherTool.assertEmpty(storePass, STORE_PASS);
        SecretInformation secretInformation = new SecretInformation();
        secretInformation.setAliasSecret(storePass);
        information.setKeyStorePasswordProvider(secretInformation);
        return information;
    }

    private static Options getOptions() {
        Options options = new Options();
        Option source = new Option(SOURCE_IN_LINED, true, "Plain text in-lined");
        Option sourceFile = new Option(SOURCE_FILE, true, "Plain text from a file");
        Option passphrase = new Option(PASSPHRASE, true, "Passphrase to use for symmetric en- or decryption.");
        Option keyStore = new Option(KEY_STORE, true, "Private key entry KeyStore");
        Option storeType = new Option(STORE_TYPE, true, " KeyStore type");
        Option storePassword = new Option(STORE_PASS, true, "Password for keyStore access");
        Option keyPassword = new Option(KEY_PASS, true, "Password for access private key entry");
        Option alias = new Option(ALIAS, true, "Alias name for identify key owner");
        Option trusted = new Option(TRUSTED, false, "Is this KeyStore trusted one");
        Option keyFile = new Option(KEY_FILE, true, "Private key from a file");
        Option cipherType = new Option(CIPHER_TYPE, true, "Cipher type");
        Option opMode = new Option(OP_MODE, true, "encrypt or decrypt");
        Option algorithm = new Option(ALGORITHM, true, "Algorithm to be used");
        Option targetFile = new Option(TARGET_FILE, true, "Target file");
        Option outType = new Option(OUT_TYPE, true, "Encode type for output");
        Option intType = new Option(IN_TYPE, true, "Encode type of input source");
        options.addOption(source);
        options.addOption(sourceFile);
        options.addOption(passphrase);
        options.addOption(keyStore);
        options.addOption(storeType);
        options.addOption(storePassword);
        options.addOption(keyPassword);
        options.addOption(alias);
        options.addOption(trusted);
        options.addOption(keyFile);
        options.addOption(algorithm);
        options.addOption(cipherType);
        options.addOption(opMode);
        options.addOption(targetFile);
        options.addOption(outType);
        options.addOption(intType);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key getKey(String filePath) {
        File keyFile;
        if (filePath == null || "".equals(filePath)) {
            CipherTool.handleException("File path cannot be empty or null");
        }
        if (!(keyFile = new File(filePath)).exists()) {
            CipherTool.handleException("File cannot be found in : " + filePath);
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(keyFile));
            Object object = in.readObject();
            if (object instanceof Key) {
                Key key = (Key)object;
                return key;
            }
        }
        catch (IOException e) {
            CipherTool.handleException("Error reading key from given path : " + filePath, e);
        }
        catch (ClassNotFoundException e) {
            CipherTool.handleException("Cannot load a key from the file : " + filePath, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private static Key findKey(CommandLine cmd, CipherInformation cipherInformation) {
        String passPhrase = CipherTool.getArgument(cmd, PASSPHRASE, null);
        Key key = null;
        if (passPhrase != null) {
            key = new SecretKeySpec(passPhrase.getBytes(), cipherInformation.getAlgorithm());
        } else {
            String keyFile = CipherTool.getArgument(cmd, KEY_FILE, null);
            if (keyFile != null) {
                key = CipherTool.getKey(keyFile);
            }
        }
        return key;
    }

    private static void handleException(String msg, Exception e) {
        log.error(msg, e);
        throw new SecureVaultException(msg, e);
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }

    private static void assertEmpty(String value, String key) {
        if (value == null || "".equals(value)) {
            CipherTool.handleException("The argument : " + key + " : cannot be null or empty.");
        }
    }
}

