/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.OptimizableOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class MonoDelayUntil<T>
extends Mono<T>
implements Scannable,
OptimizableOperator<T, T> {
    final Mono<T> source;
    Function<? super T, ? extends Publisher<?>>[] otherGenerators;
    @Nullable
    final OptimizableOperator<?, T> optimizableOperator;

    MonoDelayUntil(Mono<T> monoSource, Function<? super T, ? extends Publisher<?>> triggerGenerator) {
        this.source = Objects.requireNonNull(monoSource, "monoSource");
        this.otherGenerators = new Function[]{Objects.requireNonNull(triggerGenerator, "triggerGenerator")};
        this.optimizableOperator = this.source instanceof OptimizableOperator ? (OptimizableOperator)((Object)this.source) : null;
    }

    MonoDelayUntil(Mono<T> monoSource, Function<? super T, ? extends Publisher<?>>[] triggerGenerators) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(monoSource, "monoSource");
        this.otherGenerators = triggerGenerators;
        this.optimizableOperator = this.source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)((Object)this.source)) : null;
    }

    MonoDelayUntil<T> copyWithNewTriggerGenerator(boolean delayError, Function<? super T, ? extends Publisher<?>> triggerGenerator) {
        Objects.requireNonNull(triggerGenerator, "triggerGenerator");
        Function<? super T, ? extends Publisher<?>>[] oldTriggers = this.otherGenerators;
        Function[] newTriggers = new Function[oldTriggers.length + 1];
        System.arraycopy(oldTriggers, 0, newTriggers, 0, oldTriggers.length);
        newTriggers[oldTriggers.length] = triggerGenerator;
        return new MonoDelayUntil<T>(this.source, newTriggers);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        try {
            this.source.subscribe(this.subscribeOrReturn((CoreSubscriber<? super T>)actual));
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
    }

    @Override
    public final CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) throws Throwable {
        DelayUntilCoordinator<? super T> parent = new DelayUntilCoordinator<T>(actual, this.otherGenerators);
        actual.onSubscribe(parent);
        return parent;
    }

    @Override
    public final CorePublisher<? extends T> source() {
        return this.source;
    }

    @Override
    public final OptimizableOperator<?, ? extends T> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    static final class DelayUntilTrigger<T>
    implements InnerConsumer<T> {
        final DelayUntilCoordinator<?> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<DelayUntilTrigger, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(DelayUntilTrigger.class, Subscription.class, "s");
        boolean done;
        volatile Throwable error;

        DelayUntilTrigger(DelayUntilCoordinator<?> parent) {
            this.parent = parent;
        }

        @Override
        public Context currentContext() {
            return this.parent.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.setOnce(S, this, s2)) {
                s2.request(Long.MAX_VALUE);
            } else {
                s2.cancel();
            }
        }

        @Override
        public void onNext(Object t) {
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            if (DelayUntilCoordinator.DONE.getAndSet(this.parent, this.parent.n) != this.parent.n) {
                this.parent.cancel();
                this.parent.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.parent.signal();
            }
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class DelayUntilCoordinator<T>
    extends Operators.MonoSubscriber<T, T> {
        static final DelayUntilTrigger[] NO_TRIGGER = new DelayUntilTrigger[0];
        final int n;
        final Function<? super T, ? extends Publisher<?>>[] otherGenerators;
        volatile int done;
        static final AtomicIntegerFieldUpdater<DelayUntilCoordinator> DONE = AtomicIntegerFieldUpdater.newUpdater(DelayUntilCoordinator.class, "done");
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<DelayUntilCoordinator, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(DelayUntilCoordinator.class, Subscription.class, "s");
        DelayUntilTrigger[] triggerSubscribers;

        DelayUntilCoordinator(CoreSubscriber<? super T> subscriber, Function<? super T, ? extends Publisher<?>>[] otherGenerators) {
            super(subscriber);
            this.otherGenerators = otherGenerators;
            this.n = otherGenerators.length;
            this.triggerSubscribers = NO_TRIGGER;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.setOnce(S, this, s2)) {
                s2.request(Long.MAX_VALUE);
            } else {
                s2.cancel();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.value == null) {
                this.setValue(t);
                this.subscribeNextTrigger(t, this.done);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.value == null && this.state < 3) {
                this.actual.onComplete();
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done == this.n;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.triggerSubscribers);
        }

        void subscribeNextTrigger(T value, int triggerIndex) {
            DelayUntilTrigger triggerSubscriber;
            Publisher<?> p;
            if (this.triggerSubscribers == NO_TRIGGER) {
                this.triggerSubscribers = new DelayUntilTrigger[this.otherGenerators.length];
            }
            Function<T, Publisher<?>> generator = this.otherGenerators[triggerIndex];
            try {
                p = generator.apply(value);
                Objects.requireNonNull(p, "mapper returned null value");
            }
            catch (Throwable t) {
                this.onError(t);
                return;
            }
            this.triggerSubscribers[triggerIndex] = triggerSubscriber = new DelayUntilTrigger(this);
            p.subscribe(triggerSubscriber);
        }

        void signal() {
            int nextIndex = DONE.incrementAndGet(this);
            if (nextIndex != this.n) {
                this.subscribeNextTrigger(this.value, nextIndex);
                return;
            }
            Throwable error = null;
            Throwable compositeError = null;
            for (int i = 0; i < this.n; ++i) {
                DelayUntilTrigger mt = this.triggerSubscribers[i];
                Throwable e = mt.error;
                if (e == null) continue;
                if (compositeError != null) {
                    compositeError.addSuppressed(e);
                    continue;
                }
                if (error != null) {
                    compositeError = Exceptions.multiple(error, e);
                    continue;
                }
                error = e;
            }
            if (compositeError != null) {
                this.actual.onError(compositeError);
            } else if (error != null) {
                this.actual.onError(error);
            } else {
                this.complete(this.value);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                Operators.terminate(S, this);
                for (int i = 0; i < this.triggerSubscribers.length; ++i) {
                    DelayUntilTrigger ts = this.triggerSubscribers[i];
                    if (ts == null) continue;
                    ts.cancel();
                }
            }
        }
    }
}

