/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPoint;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointList;

public class EndpointIndividualApiIT {
    private final EndpointIndividualApi api = new EndpointIndividualApi();
    private final TestUtils testUtils = new TestUtils();
    private final EndpointCollectionApi endpointCollectionApi = new EndpointCollectionApi();

    @Test
    public void endpointsEndpointIdDeleteTest() throws ApiException {
        String endPointId1 = this.testUtils.createEndPoint("Endpoint-145", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "user", "user");
        String endPointId2 = this.testUtils.createEndPoint("Endpoint-146", "{\"serviceUrl\":\"http://petstore.swagger.io/\"}", "user", "user");
        String ifMatch = null;
        String ifModifiedSince = null;
        String ifNoneMatch = null;
        String ifUnmodifiedSince = null;
        this.api.endpointsEndpointIdDelete(endPointId1, ifMatch, ifUnmodifiedSince);
        EndPointList response = this.endpointCollectionApi.endpointsGet(ifNoneMatch, ifModifiedSince);
        for (int i = 0; i < response.getCount(); ++i) {
            if (((EndPoint)response.getList().get(i)).getName().equals("Endpoint-145")) assert (false);
        }
    }

    @Test(enabled=false)
    public void endpointsEndpointIdDeleteTest_NF() throws ApiException {
        String endPointId = "invalidEndPointId";
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            this.api.endpointsEndpointIdDelete(endPointId, ifMatch, ifUnmodifiedSince);
            assert (false);
        }
        catch (ApiException ae) {
            int statusCode = ae.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test
    public void endpointsEndpointIdGetTest() throws ApiException {
        String endPointName = "EndPoint-142";
        String endPointConfig = "{\"serviceUrl\":\"http://petstore.swagger.io/\"}";
        String username = "user";
        String password = "pass";
        String endpointId = this.testUtils.createEndPoint(endPointName, endPointConfig, username, password);
        String ifUnmodifiedSince = null;
        String ifMatch = null;
        EndPoint response = this.api.endpointsEndpointIdGet(endpointId, ifMatch, ifUnmodifiedSince);
        Assert.assertEquals((String)response.getName(), (String)"EndPoint-142", (String)"Endpoint Name mismatch");
        Assert.assertEquals((String)response.getType(), (String)"production", (String)"EndPoint type mismatch");
        Assert.assertEquals((long)response.getMaxTps(), (long)1000L, (String)"EndPoint MaxTps mismatch");
        Assert.assertEquals((String)response.getEndpointConfig(), (String)"{\"serviceUrl\":\"http://petstore.swagger.io/\"}", (String)"EndPoint config mismatch");
        Assert.assertEquals((String)response.getId(), (String)endpointId, (String)"EndPoint id mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getUsername(), (String)"user", (String)"EndPointSecurity username mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getPassword(), (String)"pass", (String)"EndPointSecurity password mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getEnabled().toString(), (String)"false", (String)"EndPointSecurity isEnable mismatch");
        Assert.assertEquals((String)response.getEndpointSecurity().getType(), (String)"http", (String)"EndPointSecurity type mismatch");
        this.testUtils.deleteEndPoint(endpointId);
    }

    @Test
    public void endpointsEndpointIdGetTest_NF() throws ApiException {
        String endpointId = "invalidEndPointId";
        String ifUnmodifiedSince = null;
        String ifMatch = null;
        try {
            this.api.endpointsEndpointIdGet(endpointId, ifMatch, ifUnmodifiedSince);
            assert (false);
        }
        catch (ApiException ae) {
            int statusCode = ae.getCode();
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"Endpoint Not Found", (String)"Error message mismatch");
        }
    }

    @Test(enabled=false)
    public void endpointsEndpointIdPutTest() throws ApiException {
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        String endPointName = "EndPoint-209";
        String endPointConfig = "{\"serviceUrl\":\"http://petstore.swagger.io/\"}";
        String username = "user";
        String password = "pass";
        String endpointId = this.testUtils.createEndPoint(endPointName, endPointConfig, username, password);
        System.out.println(endpointId);
        String endPointConfig2 = "{\"serviceUrl\":\"http://ws.cdyne.com/phoneverify/phoneverify.asmx/\"}";
        EndPoint body = new EndPoint();
        body.setEndpointConfig(endPointConfig2);
        EndPoint response = this.api.endpointsEndpointIdPut(endpointId, body, ifMatch, ifUnmodifiedSince);
        System.out.println(response);
        this.testUtils.deleteEndPoint(endpointId);
    }

    @AfterClass
    public void afterClass() throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        EndPointList response = this.endpointCollectionApi.endpointsGet(ifNoneMatch, ifModifiedSince);
        for (int i = 0; i < response.getCount(); ++i) {
            String endpointId = ((EndPoint)response.getList().get(i)).getId();
            this.api.endpointsEndpointIdDelete(endpointId, ifMatch, ifUnmodifiedSince);
            this.testUtils.deleteApi();
        }
    }
}

