/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.EndpointIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPoint;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointEndpointSecurity;

public class TestUtils {
    private final APICollectionApi api = new APICollectionApi();
    private final EndpointCollectionApi endpointCollectionApi = new EndpointCollectionApi();
    private static String apiID;
    private final EndpointIndividualApi endpointIndividualApi = new EndpointIndividualApi();

    public String createApi(String apiName, String version, String context) throws ApiException {
        API body = new API();
        body.setName(apiName);
        body.setContext(context);
        body.setVersion(version);
        body.setDescription("This is the api description");
        body.setProvider("admin");
        body.setLifeCycleStatus("CREATED");
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
            }
        });
        body.setCacheTimeout(Integer.valueOf(100));
        body.setPolicies((List)new ArrayList<String>(){
            {
                this.add("Unlimited");
            }
        });
        body.setGatewayEnvironments("Production and Sandbox");
        body.setVisibility(API.VisibilityEnum.PUBLIC);
        body.setTags(new ArrayList());
        body.setVisibleRoles(new ArrayList());
        body.setVisibleTenants(new ArrayList());
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        API response = this.api.apisPost(body);
        apiID = response.getId();
        return apiID;
    }

    public void deleteApi() throws ApiException {
        APIIndividualApi apiClient = new APIIndividualApi();
        APIList response = this.api.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        for (int i = 0; i < response.getCount(); ++i) {
            String apiId = ((APIInfo)response.getList().get(i)).getId();
            apiClient.apisApiIdDelete(apiId, ifMatch, ifUnmodifiedSince);
        }
    }

    public String createEndPoint(String endPointName, String endPointConfig, String username, String password) throws ApiException {
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        long MaxTps = 1000L;
        EndPointEndpointSecurity endPointEndpointSecurity = new EndPointEndpointSecurity();
        endPointEndpointSecurity.setEnabled(Boolean.valueOf(false));
        endPointEndpointSecurity.setType("http");
        endPointEndpointSecurity.setUsername(username);
        endPointEndpointSecurity.setPassword(password);
        EndPoint endPoint = new EndPoint();
        endPoint.setId(UUID.randomUUID().toString());
        endPoint.setName(endPointName);
        endPoint.setEndpointSecurity(endPointEndpointSecurity);
        endPoint.setType("production");
        endPoint.setMaxTps(Long.valueOf(MaxTps));
        endPoint.setEndpointConfig(endPointConfig);
        EndPoint response = this.endpointCollectionApi.endpointsPost(endPoint, ifNoneMatch, ifModifiedSince);
        return response.getId();
    }

    public void deleteEndPoint(String endPointId) throws ApiException {
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        this.endpointIndividualApi.endpointsEndpointIdDelete(endPointId, ifMatch, ifUnmodifiedSince);
    }
}

