/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressResponseBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.Document;

public class DocumentIndividualApi {
    private ApiClient apiClient;

    public DocumentIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DocumentIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdDocumentsDocumentIdContentGetCall(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}/content".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdContentGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdContentGet(Async)");
        }
        Call call = this.apisApiIdDocumentsDocumentIdContentGetCall(apiId, documentId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdDocumentsDocumentIdContentGet(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdDocumentsDocumentIdContentGetWithHttpInfo(apiId, documentId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdDocumentsDocumentIdContentGetWithHttpInfo(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(apiId, documentId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdDocumentsDocumentIdContentGetAsync(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDocumentsDocumentIdContentGetValidateBeforeCall(apiId, documentId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdDocumentsDocumentIdContentPostCall(String apiId, String documentId, File file, String inlineContent, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}/content".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (inlineContent != null) {
            localVarFormParams.put("inlineContent", inlineContent);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDocumentsDocumentIdContentPostValidateBeforeCall(String apiId, String documentId, File file, String inlineContent, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdContentPost(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdContentPost(Async)");
        }
        Call call = this.apisApiIdDocumentsDocumentIdContentPostCall(apiId, documentId, file, inlineContent, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Document apisApiIdDocumentsDocumentIdContentPost(String apiId, String documentId, File file, String inlineContent, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<Document> resp = this.apisApiIdDocumentsDocumentIdContentPostWithHttpInfo(apiId, documentId, file, inlineContent, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<Document> apisApiIdDocumentsDocumentIdContentPostWithHttpInfo(String apiId, String documentId, File file, String inlineContent, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdDocumentsDocumentIdContentPostValidateBeforeCall(apiId, documentId, file, inlineContent, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdDocumentsDocumentIdContentPostAsync(String apiId, String documentId, File file, String inlineContent, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDocumentsDocumentIdContentPostValidateBeforeCall(apiId, documentId, file, inlineContent, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdDocumentsDocumentIdDeleteCall(String apiId, String documentId, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDocumentsDocumentIdDeleteValidateBeforeCall(String apiId, String documentId, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdDelete(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdDelete(Async)");
        }
        Call call = this.apisApiIdDocumentsDocumentIdDeleteCall(apiId, documentId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdDocumentsDocumentIdDelete(String apiId, String documentId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.apisApiIdDocumentsDocumentIdDeleteWithHttpInfo(apiId, documentId, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> apisApiIdDocumentsDocumentIdDeleteWithHttpInfo(String apiId, String documentId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdDocumentsDocumentIdDeleteValidateBeforeCall(apiId, documentId, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdDocumentsDocumentIdDeleteAsync(String apiId, String documentId, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDocumentsDocumentIdDeleteValidateBeforeCall(apiId, documentId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdDocumentsDocumentIdGetCall(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDocumentsDocumentIdGetValidateBeforeCall(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdGet(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdGet(Async)");
        }
        Call call = this.apisApiIdDocumentsDocumentIdGetCall(apiId, documentId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Document apisApiIdDocumentsDocumentIdGet(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<Document> resp = this.apisApiIdDocumentsDocumentIdGetWithHttpInfo(apiId, documentId, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<Document> apisApiIdDocumentsDocumentIdGetWithHttpInfo(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdDocumentsDocumentIdGetValidateBeforeCall(apiId, documentId, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdDocumentsDocumentIdGetAsync(String apiId, String documentId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDocumentsDocumentIdGetValidateBeforeCall(apiId, documentId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdDocumentsDocumentIdPutCall(String apiId, String documentId, Document body, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Document localVarPostBody = body;
        String localVarPath = "/apis/{apiId}/documents/{documentId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDocumentsDocumentIdPutValidateBeforeCall(String apiId, String documentId, Document body, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDocumentsDocumentIdPut(Async)");
        }
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling apisApiIdDocumentsDocumentIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisApiIdDocumentsDocumentIdPut(Async)");
        }
        Call call = this.apisApiIdDocumentsDocumentIdPutCall(apiId, documentId, body, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Document apisApiIdDocumentsDocumentIdPut(String apiId, String documentId, Document body, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<Document> resp = this.apisApiIdDocumentsDocumentIdPutWithHttpInfo(apiId, documentId, body, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<Document> apisApiIdDocumentsDocumentIdPutWithHttpInfo(String apiId, String documentId, Document body, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdDocumentsDocumentIdPutValidateBeforeCall(apiId, documentId, body, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdDocumentsDocumentIdPutAsync(String apiId, String documentId, Document body, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Document> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDocumentsDocumentIdPutValidateBeforeCall(apiId, documentId, body, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Document>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

