/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressResponseBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPoint;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointList;

public class EndpointCollectionApi {
    private ApiClient apiClient;

    public EndpointCollectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EndpointCollectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call endpointsGetCall(String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointsGetValidateBeforeCall(String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.endpointsGetCall(ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public EndPointList endpointsGet(String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<EndPointList> resp = this.endpointsGetWithHttpInfo(ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<EndPointList> endpointsGetWithHttpInfo(String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.endpointsGetValidateBeforeCall(ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<EndPointList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointsGetAsync(String ifNoneMatch, String ifModifiedSince, final ApiCallback<EndPointList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointsGetValidateBeforeCall(ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EndPointList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call endpointsHeadCall(String name, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/endpoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointsHeadValidateBeforeCall(String name, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.endpointsHeadCall(name, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public void endpointsHead(String name, String ifNoneMatch) throws ApiException {
        this.endpointsHeadWithHttpInfo(name, ifNoneMatch);
    }

    public ApiResponse<Void> endpointsHeadWithHttpInfo(String name, String ifNoneMatch) throws ApiException {
        Call call = this.endpointsHeadValidateBeforeCall(name, ifNoneMatch, null, null);
        return this.apiClient.execute(call);
    }

    public Call endpointsHeadAsync(String name, String ifNoneMatch, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointsHeadValidateBeforeCall(name, ifNoneMatch, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call endpointsPostCall(EndPoint body, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EndPoint localVarPostBody = body;
        String localVarPath = "/endpoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call endpointsPostValidateBeforeCall(EndPoint body, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling endpointsPost(Async)");
        }
        Call call = this.endpointsPostCall(body, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public EndPoint endpointsPost(EndPoint body, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<EndPoint> resp = this.endpointsPostWithHttpInfo(body, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<EndPoint> endpointsPostWithHttpInfo(EndPoint body, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.endpointsPostValidateBeforeCall(body, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<EndPoint>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call endpointsPostAsync(EndPoint body, String ifNoneMatch, String ifModifiedSince, final ApiCallback<EndPoint> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.endpointsPostValidateBeforeCall(body, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EndPoint>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

