/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.0.4/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIEndpoint;

/**
 * APIOperations
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-11T19:34:51.739+05:30")
public class APIOperations {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("uritemplate")
  private String uritemplate = "/_*";

  @JsonProperty("httpVerb")
  private String httpVerb = "GET";

  @JsonProperty("authType")
  private String authType = "Any";

  @JsonProperty("policy")
  private String policy = null;

  @JsonProperty("endpoint")
  private List<APIEndpoint> endpoint = null;

  @JsonProperty("scopes")
  private List<String> scopes = null;

  public APIOperations id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(example = "postapiresource", value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public APIOperations uritemplate(String uritemplate) {
    this.uritemplate = uritemplate;
    return this;
  }

   /**
   * Get uritemplate
   * @return uritemplate
  **/
  @ApiModelProperty(value = "")
  public String getUritemplate() {
    return uritemplate;
  }

  public void setUritemplate(String uritemplate) {
    this.uritemplate = uritemplate;
  }

  public APIOperations httpVerb(String httpVerb) {
    this.httpVerb = httpVerb;
    return this;
  }

   /**
   * Get httpVerb
   * @return httpVerb
  **/
  @ApiModelProperty(value = "")
  public String getHttpVerb() {
    return httpVerb;
  }

  public void setHttpVerb(String httpVerb) {
    this.httpVerb = httpVerb;
  }

  public APIOperations authType(String authType) {
    this.authType = authType;
    return this;
  }

   /**
   * Get authType
   * @return authType
  **/
  @ApiModelProperty(value = "")
  public String getAuthType() {
    return authType;
  }

  public void setAuthType(String authType) {
    this.authType = authType;
  }

  public APIOperations policy(String policy) {
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @ApiModelProperty(example = "Unlimited", value = "")
  public String getPolicy() {
    return policy;
  }

  public void setPolicy(String policy) {
    this.policy = policy;
  }

  public APIOperations endpoint(List<APIEndpoint> endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  public APIOperations addEndpointItem(APIEndpoint endpointItem) {
    if (this.endpoint == null) {
      this.endpoint = new ArrayList<APIEndpoint>();
    }
    this.endpoint.add(endpointItem);
    return this;
  }

   /**
   * Get endpoint
   * @return endpoint
  **/
  @ApiModelProperty(value = "")
  public List<APIEndpoint> getEndpoint() {
    return endpoint;
  }

  public void setEndpoint(List<APIEndpoint> endpoint) {
    this.endpoint = endpoint;
  }

  public APIOperations scopes(List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

  public APIOperations addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<String>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Get scopes
   * @return scopes
  **/
  @ApiModelProperty(value = "")
  public List<String> getScopes() {
    return scopes;
  }

  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    APIOperations apIOperations = (APIOperations) o;
    return Objects.equals(this.id, apIOperations.id) &&
        Objects.equals(this.uritemplate, apIOperations.uritemplate) &&
        Objects.equals(this.httpVerb, apIOperations.httpVerb) &&
        Objects.equals(this.authType, apIOperations.authType) &&
        Objects.equals(this.policy, apIOperations.policy) &&
        Objects.equals(this.endpoint, apIOperations.endpoint) &&
        Objects.equals(this.scopes, apIOperations.scopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, uritemplate, httpVerb, authType, policy, endpoint, scopes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class APIOperations {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    uritemplate: ").append(toIndentedString(uritemplate)).append("\n");
    sb.append("    httpVerb: ").append(toIndentedString(httpVerb)).append("\n");
    sb.append("    authType: ").append(toIndentedString(authType)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    endpoint: ").append(toIndentedString(endpoint)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

