/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.0.4/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointEndpointConfigCircuitBreakerRollingWindow;

/**
 * EndPointEndpointConfigCircuitBreaker
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-11T19:34:51.739+05:30")
public class EndPointEndpointConfigCircuitBreaker {
  @JsonProperty("rollingWindow")
  private EndPointEndpointConfigCircuitBreakerRollingWindow rollingWindow = null;

  @JsonProperty("failureThreshold")
  private String failureThreshold = null;

  @JsonProperty("resetTime")
  private Integer resetTime = null;

  public EndPointEndpointConfigCircuitBreaker rollingWindow(EndPointEndpointConfigCircuitBreakerRollingWindow rollingWindow) {
    this.rollingWindow = rollingWindow;
    return this;
  }

   /**
   * Get rollingWindow
   * @return rollingWindow
  **/
  @ApiModelProperty(value = "")
  public EndPointEndpointConfigCircuitBreakerRollingWindow getRollingWindow() {
    return rollingWindow;
  }

  public void setRollingWindow(EndPointEndpointConfigCircuitBreakerRollingWindow rollingWindow) {
    this.rollingWindow = rollingWindow;
  }

  public EndPointEndpointConfigCircuitBreaker failureThreshold(String failureThreshold) {
    this.failureThreshold = failureThreshold;
    return this;
  }

   /**
   * The threshold for request failures.When this threshold exceeds, the circuit trips.This is the ratio between failures and total requests and the ratio is considered only within the configured rolling window. 
   * @return failureThreshold
  **/
  @ApiModelProperty(example = "0.2", value = "The threshold for request failures.When this threshold exceeds, the circuit trips.This is the ratio between failures and total requests and the ratio is considered only within the configured rolling window. ")
  public String getFailureThreshold() {
    return failureThreshold;
  }

  public void setFailureThreshold(String failureThreshold) {
    this.failureThreshold = failureThreshold;
  }

  public EndPointEndpointConfigCircuitBreaker resetTime(Integer resetTime) {
    this.resetTime = resetTime;
    return this;
  }

   /**
   * The time period(in milliseconds) to wait before attempting to make another request to the upstream service 
   * @return resetTime
  **/
  @ApiModelProperty(example = "1000", value = "The time period(in milliseconds) to wait before attempting to make another request to the upstream service ")
  public Integer getResetTime() {
    return resetTime;
  }

  public void setResetTime(Integer resetTime) {
    this.resetTime = resetTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EndPointEndpointConfigCircuitBreaker endPointEndpointConfigCircuitBreaker = (EndPointEndpointConfigCircuitBreaker) o;
    return Objects.equals(this.rollingWindow, endPointEndpointConfigCircuitBreaker.rollingWindow) &&
        Objects.equals(this.failureThreshold, endPointEndpointConfigCircuitBreaker.failureThreshold) &&
        Objects.equals(this.resetTime, endPointEndpointConfigCircuitBreaker.resetTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rollingWindow, failureThreshold, resetTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EndPointEndpointConfigCircuitBreaker {\n");
    
    sb.append("    rollingWindow: ").append(toIndentedString(rollingWindow)).append("\n");
    sb.append("    failureThreshold: ").append(toIndentedString(failureThreshold)).append("\n");
    sb.append("    resetTime: ").append(toIndentedString(resetTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

