/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.store;

import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.ApplicationIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.SubscriptionCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.SubscriptionIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Subscription;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.SubscriptionList;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class APISubscriptionTestCaseIT {
    private Application application;
    private Subscription subscription;
    ApplicationIndividualApi applicationIndividualApi;
    SubscriptionIndividualApi subscriptionIndividualApi;

    @BeforeClass
    public void init() throws AMIntegrationTestException {
        this.applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        this.subscriptionIndividualApi = (SubscriptionIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionIndividualApi.class);
    }

    @Test
    public void testCreateApplication() {
        this.application = new Application().name("testApplication1").description("This is a Test App").throttlingTier("Unlimited");
        this.application = this.applicationIndividualApi.applicationsPost(this.application);
    }

    @Test(enabled=false)
    public void testCreateApplicationWithInSufficientPermissionNegative() throws AMIntegrationTestException {
        ApplicationIndividualApi applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        Application application2 = new Application().name("testApplication1").description("This is a Test App").throttlingTier("Unlimited");
        try {
            applicationIndividualApi.applicationsPost(application2);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test(dependsOnMethods={"testCreateApplication"})
    public void testCreateSubscription() {
        this.subscription = new Subscription().apiIdentifier(TestUtil.getApi((String)"baseapi1").getId()).applicationId(this.application.getApplicationId()).policy("Gold");
        this.subscription = this.subscriptionIndividualApi.subscriptionsPost(this.subscription);
    }

    @Test(dependsOnMethods={"testCreateSubscription"})
    public void testGetAllSubscriptionsByApplication() throws AMIntegrationTestException {
        SubscriptionCollectionApi subscriptionCollectionApi = (SubscriptionCollectionApi)TestUtil.getStoreApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionCollectionApi.class);
        SubscriptionList subscriptionList = subscriptionCollectionApi.subscriptionsGet("", this.application.getApplicationId(), "", Integer.valueOf(0), Integer.valueOf(10), "");
        Assert.assertNotNull((Object)subscriptionList);
        Assert.assertEquals((int)subscriptionList.getCount(), (int)1);
        Subscription subscription = (Subscription)subscriptionList.getList().get(0);
        Assert.assertEquals((String)subscription.getApiIdentifier(), (String)this.subscription.getApiIdentifier());
        Assert.assertEquals((String)subscription.getPolicy(), (String)this.subscription.getPolicy());
    }

    @Test(dependsOnMethods={"testCreateSubscription"})
    public void testGetAllSubscriptionsByAPIId() throws AMIntegrationTestException {
        SubscriptionCollectionApi subscriptionCollectionApi = (SubscriptionCollectionApi)TestUtil.getStoreApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionCollectionApi.class);
        SubscriptionList subscriptionList = subscriptionCollectionApi.subscriptionsGet(this.subscription.getApiIdentifier(), "", "", Integer.valueOf(0), Integer.valueOf(10), "");
        Assert.assertNotNull((Object)subscriptionList);
        Assert.assertEquals((int)subscriptionList.getCount(), (int)1);
        Subscription subscription = (Subscription)subscriptionList.getList().get(0);
        Assert.assertEquals((String)subscription.getApplicationId(), (String)this.subscription.getApplicationId());
        Assert.assertEquals((String)subscription.getPolicy(), (String)this.subscription.getPolicy());
    }

    @AfterClass
    public void destroy() {
        if (this.subscriptionIndividualApi.subscriptionsSubscriptionIdGet(this.subscription.getSubscriptionId(), "", "") != null) {
            this.subscriptionIndividualApi.subscriptionsSubscriptionIdDelete(this.subscription.getSubscriptionId(), "", "");
        }
        if (this.applicationIndividualApi.applicationsApplicationIdGet(this.application.getApplicationId(), "", "") != null) {
            this.applicationIndividualApi.applicationsApplicationIdDelete(this.application.getApplicationId(), "", "");
        }
    }
}

