/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import feign.Response;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.core.auth.DCRMServiceStub;
import org.wso2.carbon.apimgt.core.auth.DCRMServiceStubFactory;
import org.wso2.carbon.apimgt.core.auth.OAuth2ServiceStubs;
import org.wso2.carbon.apimgt.core.auth.dto.DCRClientInfo;
import org.wso2.carbon.apimgt.core.auth.dto.OAuth2TokenInfo;
import org.wso2.carbon.apimgt.core.exception.APIManagementException;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.api.GroupIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.api.GroupsApi;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.api.UserIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.api.UsersApi;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.model.Group;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.model.Member;
import org.wso2.carbon.apimgt.rest.integration.tests.scim.model.User;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.ApplicationIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.util.API;
import org.wso2.carbon.apimgt.rest.integration.tests.util.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.util.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.util.Application;
import org.wso2.carbon.apimgt.rest.integration.tests.util.ApplicationList;
import org.wso2.carbon.apimgt.rest.integration.tests.util.Groups;
import org.wso2.carbon.apimgt.rest.integration.tests.util.SampleTestObjectCreator;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TokenInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.util.UserGroups;
import org.wso2.carbon.apimgt.rest.integration.tests.util.Users;

public class TestUtil {
    private static Logger logger = LoggerFactory.getLogger(TestUtil.class);
    public static String clientId;
    private static String clientSecret;
    public static final String APIM_HOST;
    public static final String TOKEN_ENDPOINT_URL;
    public static final String DYNAMIC_CLIENT_REGISTRATION_ENDPOINT;
    public static final String username = "admin";
    public static final String password = "admin";
    public static final String KEY_MANAGER_CERT_ALIAS = "wso2carbon";
    public static UserGroups usersMap;
    private static Map<String, User> userMap;
    private static Set<Group> groupSet;
    private static Map<String, org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application> applicationMap;
    private static Map<String, org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API> apiMap;
    public static Users users;
    public static Groups groups;
    public static ApplicationList applicationList;
    public static APIList apiList;

    public static TokenInfo generateToken(String username, String password, String scopes) throws AMIntegrationTestException {
        if (StringUtils.isEmpty((CharSequence)clientId) | StringUtils.isEmpty((CharSequence)clientSecret)) {
            try {
                TestUtil.generateClient();
            }
            catch (APIManagementException e) {
                throw new AMIntegrationTestException(e);
            }
        }
        OAuth2ServiceStubs.TokenServiceStub tokenServiceStub = TestUtil.getOauth2Client();
        Response response = tokenServiceStub.generatePasswordGrantAccessToken(username, password, scopes, -1L, clientId, clientSecret);
        return TestUtil.getTokenInfo(response);
    }

    private static DCRClientInfo generateClient() throws APIManagementException {
        DCRClientInfo dcrClientInfo = new DCRClientInfo();
        dcrClientInfo.setClientName("apim-integration-test");
        dcrClientInfo.setGrantTypes(Arrays.asList("password", "client_credentials"));
        try {
            Response response = TestUtil.getDcrmServiceStub("admin", "admin").registerApplication(dcrClientInfo);
            DCRClientInfo dcrClientInfoResponse = TestUtil.getDCRClientInfo(response);
            clientId = dcrClientInfoResponse.getClientId();
            clientSecret = dcrClientInfoResponse.getClientSecret();
            return dcrClientInfoResponse;
        }
        catch (IOException | APIManagementException e) {
            logger.error("Couldn't create client", e);
            throw new APIManagementException("Couldn't create client", e);
        }
    }

    public static DCRMServiceStub getDcrmServiceStub(String username, String password) throws APIManagementException {
        return DCRMServiceStubFactory.getDCRMServiceStub((String)DYNAMIC_CLIENT_REGISTRATION_ENDPOINT, (String)username, (String)password, (String)KEY_MANAGER_CERT_ALIAS);
    }

    public static DCRClientInfo getDCRClientInfo(Response response) throws IOException {
        return (DCRClientInfo)new GsonDecoder().decode(response, DCRClientInfo.class);
    }

    private static OAuth2ServiceStubs.TokenServiceStub getOauth2Client() throws AMIntegrationTestException {
        try {
            return new OAuth2ServiceStubs(TOKEN_ENDPOINT_URL, "", "", "", KEY_MANAGER_CERT_ALIAS, "admin", "admin").getTokenServiceStub();
        }
        catch (APIManagementException e) {
            throw new AMIntegrationTestException(e);
        }
    }

    public static String getIpAddressOfContainer() {
        String ip = "localhost:9443";
        String dockerHost = System.getenv("SERVER_HOST");
        if (!StringUtils.isEmpty((CharSequence)dockerHost)) {
            return dockerHost;
        }
        return ip;
    }

    public static void initConfiguration() throws AMIntegrationTestException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            usersMap = (UserGroups)objectMapper.readValue(TestUtil.class.getResource("/users.yaml"), UserGroups.class);
            users = (Users)objectMapper.readValue(TestUtil.class.getResource("/users.yaml"), Users.class);
            groups = (Groups)objectMapper.readValue(TestUtil.class.getResource("/users.yaml"), Groups.class);
            applicationList = (ApplicationList)objectMapper.readValue(TestUtil.class.getResource("/users.yaml"), ApplicationList.class);
            apiList = (APIList)objectMapper.readValue(TestUtil.class.getResource("/users.yaml"), APIList.class);
        }
        catch (IOException e) {
            throw new AMIntegrationTestException(e);
        }
        TestUtil.createUsers();
        TestUtil.createInitialApplications();
        TestUtil.createInitialApis();
    }

    private static void createUsers() throws AMIntegrationTestException {
        UsersApi usersApi = new ApiClient(APIM_HOST + "/api/identity/scim2/v1.0", "admin", "admin").buildClient(UsersApi.class);
        for (Map.Entry<String, String> user : users.getUsers().entrySet()) {
            User scimUser = new User().userName(user.getKey()).password(user.getValue());
            scimUser = usersApi.usersPost(scimUser);
            userMap.put(user.getKey(), scimUser);
        }
        GroupsApi groupsApi = new ApiClient(APIM_HOST + "/api/identity/scim2/v1.0", "admin", "admin").buildClient(GroupsApi.class);
        groups.getGroups().forEach((group, userList) -> {
            Group group1 = new Group().displayName((String)group);
            for (String user : userList) {
                group1.addMembersItem(new Member().value(userMap.get(user).getId()));
            }
            groupSet.add(groupsApi.groupsPost(group1));
        });
    }

    public static void cleanupUsers() throws AMIntegrationTestException {
        UserIndividualApi userIndividualApi = new ApiClient(APIM_HOST + "/api/identity/scim2/v1.0", "admin", "admin").buildClient(UserIndividualApi.class);
        GroupIndividualApi groupIndividualApi = new ApiClient(APIM_HOST + "/api/identity/scim2/v1.0", "admin", "admin").buildClient(GroupIndividualApi.class);
        userMap.values().forEach(user -> userIndividualApi.usersIdDelete(user.getId()));
        groupSet.forEach(group -> groupIndividualApi.groupsIdDelete(group.getId()));
    }

    public static ApiClient getPublisherApiClient(String username, String password, String scopes) throws AMIntegrationTestException {
        return new ApiClient(APIM_HOST + "/api/am/publisher/v1.0", username, password, scopes);
    }

    public static ApiClient getStoreApiClient(String username, String password, String scopes) throws AMIntegrationTestException {
        return new ApiClient(APIM_HOST + "/api/am/store/v1.0", username, password, scopes);
    }

    public static ApiClient getAdminApiClient(String username, String password, String scopes) throws AMIntegrationTestException {
        return new ApiClient(APIM_HOST + "/api/am/admin/v1.0", username, password, scopes);
    }

    public static String getUser(String username) {
        return users.getUsers().get(username);
    }

    public static List<String> getGroupsOfUser(String username) {
        ArrayList<String> groupList = new ArrayList<String>();
        groups.getGroups().forEach((group, userList) -> {
            if (userList.contains(username)) {
                groupList.add((String)group);
            }
        });
        return groupList;
    }

    public static Set<String> getApimUserGroupsOfUser(String username) {
        HashSet<String> userGroups = new HashSet<String>();
        List<String> groupList = TestUtil.getGroupsOfUser(username);
        groupList.forEach(group -> {
            if (usersMap.getAdmin().contains(group)) {
                userGroups.add("admin");
            }
            if (usersMap.getCreator().contains(group)) {
                userGroups.add("creator");
            }
            if (usersMap.getPublisher().contains(group)) {
                userGroups.add("publisher");
            }
            if (usersMap.getSubscriber().contains(group)) {
                userGroups.add("subscriber");
            }
        });
        return userGroups;
    }

    public static void createInitialApplications() throws AMIntegrationTestException {
        for (Application application : applicationList.getApplications()) {
            ApplicationIndividualApi applicationIndividualApi = TestUtil.getStoreApiClient(application.getUser(), TestUtil.getUser(application.getUser()), "apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
            applicationMap.put(application.getName(), applicationIndividualApi.applicationsPost(new org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application().name(application.getName()).description(application.getDescription()).throttlingTier(application.getThrottlingTier())));
        }
    }

    public static void createInitialApis() throws AMIntegrationTestException {
        for (API api : apiList.getApis()) {
            APICollectionApi apiCollectionApi = TestUtil.getPublisherApiClient(api.getUser(), TestUtil.getUser(api.getUser()), "apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
            org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API apiToCreate = SampleTestObjectCreator.ApiToCreate(api.getName(), api.getVersion(), api.getContext()).description(api.getDescription()).policies(api.getSubscriptionPolicies()).visibleRoles(api.getVisibleRoles()).visibility(API.VisibilityEnum.fromValue(api.getVisibility()));
            apiToCreate = apiCollectionApi.apisPost(apiToCreate);
            APIIndividualApi apiIndividualApi = TestUtil.getPublisherApiClient(api.getUser(), TestUtil.getUser(api.getUser()), "apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
            for (String status : api.getLifecycleStatusChain()) {
                apiIndividualApi.apisChangeLifecyclePost(status, apiToCreate.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
            }
            apiMap.put(apiToCreate.getName(), apiToCreate);
        }
    }

    public static void destroyApplications() throws AMIntegrationTestException {
        for (Application application : applicationList.getApplications()) {
            ApplicationIndividualApi applicationIndividualApi = TestUtil.getStoreApiClient(application.getUser(), TestUtil.getUser(application.getUser()), "apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
            if (!applicationMap.containsKey(application.getName())) continue;
            applicationIndividualApi.applicationsApplicationIdDelete(applicationMap.get(application.getName()).getApplicationId(), "", "");
        }
    }

    public static void destroyApis() throws AMIntegrationTestException {
        for (API api : apiList.getApis()) {
            APIIndividualApi apiIndividualApi = TestUtil.getPublisherApiClient(api.getUser(), TestUtil.getUser(api.getUser()), "apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
            if (!apiMap.containsKey(api.getName())) continue;
            apiIndividualApi.apisApiIdDelete(apiMap.get(api.getName()).getId(), "", "");
        }
    }

    public static org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application getApplication(String applicationName) {
        return applicationMap.get(applicationName);
    }

    public static org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API getApi(String apiName) {
        return apiMap.get(apiName);
    }

    public static TokenInfo generateToken(String scopes, String refreshToken) throws AMIntegrationTestException {
        if (StringUtils.isEmpty((CharSequence)clientId) | StringUtils.isEmpty((CharSequence)clientSecret)) {
            try {
                TestUtil.generateClient();
            }
            catch (APIManagementException e) {
                throw new AMIntegrationTestException(e);
            }
        }
        OAuth2ServiceStubs.TokenServiceStub tokenServiceStub = TestUtil.getOauth2Client();
        Response response = tokenServiceStub.generateRefreshGrantAccessToken(refreshToken, scopes, -1L, clientId, clientSecret);
        return TestUtil.getTokenInfo(response);
    }

    private static TokenInfo getTokenInfo(Response response) throws AMIntegrationTestException {
        if (response.status() == 200) {
            logger.debug("A new access token is successfully generated.");
            try {
                OAuth2TokenInfo oAuth2TokenInfo = (OAuth2TokenInfo)new GsonDecoder().decode(response, OAuth2TokenInfo.class);
                return new TokenInfo(oAuth2TokenInfo.getAccessToken(), System.currentTimeMillis() + oAuth2TokenInfo.getExpiresIn(), oAuth2TokenInfo.getRefreshToken());
            }
            catch (IOException e) {
                throw new AMIntegrationTestException("Error occurred while parsing token response", e);
            }
        }
        throw new AMIntegrationTestException("Error occurred while Generating token");
    }

    static {
        APIM_HOST = "https://" + TestUtil.getIpAddressOfContainer();
        TOKEN_ENDPOINT_URL = APIM_HOST + "/api/auth/oauth2/v1.0/token";
        DYNAMIC_CLIENT_REGISTRATION_ENDPOINT = "https://" + TestUtil.getIpAddressOfContainer() + "/api/identity/oauth2/dcr/v1.0/register";
        userMap = new HashMap<String, User>();
        groupSet = new HashSet<Group>();
        applicationMap = new HashMap<String, org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application>();
        apiMap = new HashMap<String, org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API>();
    }
}

