/*
 * WSO2 API Manager - Store
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Store.  It is written with [swagger 2](http://swagger.io/). 
 *
 * OpenAPI spec version: v1.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.store.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ApplicationToken
 */

public class ApplicationToken {
  @JsonProperty("accessToken")
  private String accessToken = null;

  @JsonProperty("tokenScopes")
  private String tokenScopes = null;

  @JsonProperty("validityTime")
  private Long validityTime = null;

  public ApplicationToken accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

   /**
   * Access token
   * @return accessToken
  **/
  @ApiModelProperty(value = "Access token")
  public String getAccessToken() {
    return accessToken;
  }

  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }

  public ApplicationToken tokenScopes(String tokenScopes) {
    this.tokenScopes = tokenScopes;
    return this;
  }

   /**
   * Valid scopes for the access token
   * @return tokenScopes
  **/
  @ApiModelProperty(value = "Valid scopes for the access token")
  public String getTokenScopes() {
    return tokenScopes;
  }

  public void setTokenScopes(String tokenScopes) {
    this.tokenScopes = tokenScopes;
  }

  public ApplicationToken validityTime(Long validityTime) {
    this.validityTime = validityTime;
    return this;
  }

   /**
   * Maximum validity time for the access token
   * @return validityTime
  **/
  @ApiModelProperty(value = "Maximum validity time for the access token")
  public Long getValidityTime() {
    return validityTime;
  }

  public void setValidityTime(Long validityTime) {
    this.validityTime = validityTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationToken applicationToken = (ApplicationToken) o;
    return Objects.equals(this.accessToken, applicationToken.accessToken) &&
        Objects.equals(this.tokenScopes, applicationToken.tokenScopes) &&
        Objects.equals(this.validityTime, applicationToken.validityTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessToken, tokenScopes, validityTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationToken {\n");
    
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    tokenScopes: ").append(toIndentedString(tokenScopes)).append("\n");
    sb.append("    validityTime: ").append(toIndentedString(validityTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

