/**
 * Copyright (c) 2018, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 * <p>
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import static org.apache.commons.lang3.time.DateUtils.MILLIS_PER_SECOND;

public class TokenInfo {
    private String token;
    private long expiryTime;
    private String refreshToken;

    public TokenInfo(String token, long expiryTime, String refreshToken) {
        this.token = token;
        this.expiryTime = System.currentTimeMillis() + expiryTime * MILLIS_PER_SECOND;
        this.refreshToken = refreshToken;
    }

    public String getToken() {
        return token;
    }

    public long getExpiryTime() {
        return expiryTime;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    @Override
    public String toString() {

        return "TokenInfo{" +
                "token='" + token + '\'' +
                ", expiryTime=" + expiryTime +
                ", refreshToken='" + refreshToken + '\'' +
                '}';
    }
}
