/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.oauth;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import feign.Response;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.core.auth.DCRMServiceStub;
import org.wso2.carbon.apimgt.core.auth.dto.DCRClientInfo;
import org.wso2.carbon.apimgt.core.auth.dto.OAuth2TokenInfo;
import org.wso2.carbon.apimgt.core.exception.APIManagementException;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class JWTTokenGrantTestCaseIT {
    DCRClientInfo dcrClientInfo;

    @BeforeClass
    public void setup() throws APIManagementException, IOException {
        this.dcrClientInfo = new DCRClientInfo();
        this.dcrClientInfo.setGrantTypes(Arrays.asList("client_credentials", "password", "refresh_token"));
        this.dcrClientInfo.setClientName("JWTTokenGrantTestCaseIT");
        this.dcrClientInfo.setTokenType("JWT");
        this.dcrClientInfo.setAudiences(Arrays.asList("http://org.wso2.apimgt/gateway"));
        DCRMServiceStub dcrmServiceStub = TestUtil.getDcrmServiceStub((String)"admin", (String)"admin");
        Response response = dcrmServiceStub.registerApplication(this.dcrClientInfo);
        this.dcrClientInfo = TestUtil.getDCRClientInfo((Response)response);
        Assert.assertNotNull((Object)this.dcrClientInfo);
        Assert.assertEquals((Collection)this.dcrClientInfo.getAudiences(), Arrays.asList("http://org.wso2.apimgt/gateway"));
    }

    @Test
    public void testGenerateTokenFromRefreshToken() throws AMIntegrationTestException, ParseException {
        OAuth2TokenInfo tokenInfo = TestUtil.generateToken((String)this.dcrClientInfo.getClientId(), (String)this.dcrClientInfo.getClientSecret(), (String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"default");
        Assert.assertNotNull((Object)tokenInfo);
        Assert.assertNotNull((Object)tokenInfo.getRefreshToken());
        SignedJWT signedJWT = SignedJWT.parse((String)tokenInfo.getAccessToken());
        ReadOnlyJWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
        Assert.assertTrue((boolean)jwtClaimsSet.getExpirationTime().after(jwtClaimsSet.getIssueTime()));
        Assert.assertEquals((Object)jwtClaimsSet.getClaim("scope"), (Object)"default");
        Assert.assertEquals((String)jwtClaimsSet.getIssuer(), (String)"https://localhost:9443/oauth2/token");
        Assert.assertEquals((Collection)jwtClaimsSet.getAudience(), Arrays.asList("http://org.wso2.apimgt/gateway"));
        OAuth2TokenInfo refreshTokenInfo = TestUtil.generateToken((String)this.dcrClientInfo.getClientId(), (String)this.dcrClientInfo.getClientSecret(), (String)tokenInfo.getRefreshToken(), (String)"apim:api_view");
        Assert.assertNotNull((Object)refreshTokenInfo);
        signedJWT = SignedJWT.parse((String)refreshTokenInfo.getAccessToken());
        jwtClaimsSet = signedJWT.getJWTClaimsSet();
        Assert.assertTrue((boolean)jwtClaimsSet.getExpirationTime().after(jwtClaimsSet.getIssueTime()));
        Assert.assertEquals((String)jwtClaimsSet.getIssuer(), (String)"https://localhost:9443/oauth2/token");
        Assert.assertEquals((Object)jwtClaimsSet.getClaim("scope"), (Object)"apim:api_view");
        Assert.assertEquals((Collection)jwtClaimsSet.getAudience(), Arrays.asList("http://org.wso2.apimgt/gateway"));
    }
}

