/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.oauth;

import feign.Response;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.core.auth.DCRMServiceStub;
import org.wso2.carbon.apimgt.core.auth.dto.DCRClientInfo;
import org.wso2.carbon.apimgt.core.auth.dto.OAuth2TokenInfo;
import org.wso2.carbon.apimgt.core.exception.APIManagementException;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class RefreshGrantTestCaseIT {
    private static Logger logger = LoggerFactory.getLogger(RefreshGrantTestCaseIT.class);
    DCRClientInfo dcrClientInfo;

    @BeforeClass
    public void setup() throws APIManagementException, IOException {
        this.dcrClientInfo = new DCRClientInfo();
        this.dcrClientInfo.setGrantTypes(Arrays.asList("client_credentials", "password", "refresh_token"));
        this.dcrClientInfo.setClientName("RefreshGrantTestCaseIT");
        DCRMServiceStub dcrmServiceStub = TestUtil.getDcrmServiceStub((String)"admin", (String)"admin");
        Response response = dcrmServiceStub.registerApplication(this.dcrClientInfo);
        this.dcrClientInfo = TestUtil.getDCRClientInfo((Response)response);
        Assert.assertNotNull((Object)this.dcrClientInfo);
    }

    @Test
    public void testGenerateTokenFromRefreshToken() throws AMIntegrationTestException {
        OAuth2TokenInfo tokenInfo = TestUtil.generateToken((String)this.dcrClientInfo.getClientId(), (String)this.dcrClientInfo.getClientSecret(), (String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view");
        Assert.assertNotNull((Object)tokenInfo);
        Assert.assertTrue((boolean)tokenInfo.getScope().contains("apim:api_view"));
        Assert.assertNotNull((Object)tokenInfo.getRefreshToken());
        OAuth2TokenInfo refreshTokenInfo = TestUtil.generateToken((String)this.dcrClientInfo.getClientId(), (String)this.dcrClientInfo.getClientSecret(), (String)tokenInfo.getRefreshToken(), null);
        Assert.assertNotNull((Object)refreshTokenInfo);
        Assert.assertTrue((boolean)refreshTokenInfo.getScope().contains("apim:api_view"));
        OAuth2TokenInfo refreshTokenInfoWithScopes = TestUtil.generateToken((String)this.dcrClientInfo.getClientId(), (String)this.dcrClientInfo.getClientSecret(), (String)refreshTokenInfo.getRefreshToken(), (String)"apim:api_view apim:api_create");
        Assert.assertNotNull((Object)refreshTokenInfo);
        Assert.assertTrue((boolean)refreshTokenInfoWithScopes.getScope().contains("apim:api_view"));
        Assert.assertTrue((boolean)refreshTokenInfoWithScopes.getScope().contains("apim:api_create"));
        logger.info(refreshTokenInfo.toString());
    }
}

