/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher;

import java.io.File;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.core.models.APIStatus;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.FileInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.util.SampleTestObjectCreator;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class APILifeCycleTestCaseIT {
    private API api;

    @Test
    public void testCreateApi() throws AMIntegrationTestException {
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        this.api = SampleTestObjectCreator.ApiToCreate((String)"api1-lifecycle", (String)"1.0.0", (String)"/apiLifecycle");
        this.api = apiCollectionApi.apisPost(this.api);
        Assert.assertNotNull((Object)this.api.getId());
    }

    @Test(dependsOnMethods={"testCreateApi"})
    public void testUpdateApi() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        this.api.addPoliciesItem("Gold");
        this.api.addTransportItem("http");
        this.api = apiIndividualApi.apisApiIdPut(this.api.getId(), this.api, "", "");
    }

    @Test(dependsOnMethods={"testUpdateApi"})
    public void testUpdateImage() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        FileInfo fileInfo = apiIndividualApi.apisApiIdThumbnailPost(this.api.getId(), new File(Thread.currentThread().getContextClassLoader().getResource("img1.jpg").getPath()), null, null);
        apiIndividualApi.apisApiIdThumbnailGet(this.api.getId(), null, null);
    }

    @Test(dependsOnMethods={"testUpdateImage"})
    public void testMakeApiProtoType() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user3", (String)TestUtil.getUser((String)"user3"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        apiIndividualApi.apisChangeLifecyclePost(APIStatus.PROTOTYPED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.PROTOTYPED.getStatus());
    }

    @Test(dependsOnMethods={"testMakeApiProtoType"})
    public void testMakeApiPublishedNegative() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        try {
            apiIndividualApi.apisChangeLifecyclePost(APIStatus.PUBLISHED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
            Assert.fail((String)"Fail due to change lifecycle from non publisher user get success");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test(dependsOnMethods={"testMakeApiProtoType"})
    public void testMakeApiPublished() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user3", (String)TestUtil.getUser((String)"user3"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        apiIndividualApi.apisChangeLifecyclePost(APIStatus.PUBLISHED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.PUBLISHED.getStatus());
    }

    @Test(dependsOnMethods={"testMakeApiPublished"})
    public void testCopyApiVersion() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        apiIndividualApi.apisCopyApiPost("v2.0.0", this.api.getId());
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(2), Integer.valueOf(0), "name:api1-lifecycle", "", Boolean.valueOf(false));
        Assert.assertNotNull((Object)apiList);
        Assert.assertTrue((apiList.getCount() > 1 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"testCopyApiVersion"})
    public void testMakeApiDeprecated() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user3", (String)TestUtil.getUser((String)"user3"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        apiIndividualApi.apisChangeLifecyclePost(APIStatus.DEPRECATED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.DEPRECATED.getStatus());
        org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi apiCollectionApi = (org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi.class);
        org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(10), Integer.valueOf(0), "", "", "");
        Assert.assertNotNull((Object)apiList);
        Assert.assertNotNull((Object)apiList.getList());
        for (org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIInfo apiInfo : apiList.getList()) {
            Assert.assertNotEquals((Object)this.api.getId(), (Object)apiInfo.getId());
        }
    }

    @Test(dependsOnMethods={"testMakeApiDeprecated"})
    public void testMakeApiRetired() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user3", (String)TestUtil.getUser((String)"user3"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        apiIndividualApi.apisChangeLifecyclePost(APIStatus.RETIRED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
    }

    @Test(dependsOnMethods={"testCreateApi"})
    public void testGetExpandedAPI() throws AMIntegrationTestException {
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(2), Integer.valueOf(0), "name:api1-lifecycle,version:1.0.0", "", Boolean.valueOf(true));
        Assert.assertNotNull((Object)apiList);
        Assert.assertTrue((apiList.getCount() == 1 ? 1 : 0) != 0);
        API api = (API)apiList.getList().get(0);
        Assert.assertTrue((boolean)api.getTransport().contains("http"));
    }

    @AfterClass
    public void destroy() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(10), Integer.valueOf(0), "name:api1-lifecycle", "", Boolean.valueOf(false));
        for (APIInfo apiInfo : apiList.getList()) {
            if (!this.api.getName().equals(apiInfo.getName())) continue;
            apiIndividualApi.apisApiIdDelete(apiInfo.getId(), "", "");
        }
    }
}

