/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.store;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.RestAPIException;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.ApplicationIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.SubscriptionIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Subscription;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class APIVisibilityTestCaseIT {
    private APIInfo apiInfo;
    List<Application> applicationList = new ArrayList<Application>();

    @Test(description="user only available in visible group")
    public void testAPIVisibleToUserInRestrictedGroup() throws AMIntegrationTestException {
        Application application = new Application().name("APIVisibilityTestCaseIT1").throttlingTier("Unlimited");
        ApplicationIndividualApi applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user7", (String)TestUtil.getUser((String)"user7"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        SubscriptionIndividualApi subscriptionIndividualApi = (SubscriptionIndividualApi)TestUtil.getStoreApiClient((String)"user7", (String)TestUtil.getUser((String)"user7"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionIndividualApi.class);
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getStoreApiClient((String)"user7", (String)TestUtil.getUser((String)"user7"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(3), Integer.valueOf(0), null, "", null);
        Assert.assertTrue((apiList.getCount() > 0 ? 1 : 0) != 0);
        APIInfo retrievedAPIInfo = null;
        for (APIInfo apiInfo : apiList.getList()) {
            if (!"restrictedapi1".equals(apiInfo.getName())) continue;
            retrievedAPIInfo = apiInfo;
            break;
        }
        Assert.assertNotNull(retrievedAPIInfo);
        Assert.assertEquals((Object)retrievedAPIInfo.getName(), (Object)"restrictedapi1");
        Assert.assertEquals((Object)retrievedAPIInfo.getVersion(), (Object)"1.0.0");
        Assert.assertEquals((Object)retrievedAPIInfo.getLifeCycleStatus(), (Object)"Published");
        Assert.assertEquals((Object)retrievedAPIInfo.getContext(), (Object)"/restrictedapi1/1.0.0");
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getStoreApiClient((String)"user7", (String)TestUtil.getUser((String)"user7"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        API api = apiIndividualApi.apisApiIdGet(retrievedAPIInfo.getId(), null, null);
        Assert.assertNotNull((Object)api);
        application = applicationIndividualApi.applicationsPost(application);
        this.applicationList.add(application);
        Subscription subscription = new Subscription().policy("Unlimited").applicationId(application.getApplicationId()).apiIdentifier(api.getId());
        subscriptionIndividualApi.subscriptionsPost(subscription);
        this.apiInfo = retrievedAPIInfo;
    }

    @Test(description="user available in multiple groups with restricted group", dependsOnMethods={"testAPIVisibleToUserInRestrictedGroup"})
    public void testAPIVisibleToUserInMultipleGroup() throws AMIntegrationTestException {
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getStoreApiClient((String)"user6", (String)TestUtil.getUser((String)"user6"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        ApplicationIndividualApi applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user6", (String)TestUtil.getUser((String)"user6"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        SubscriptionIndividualApi subscriptionIndividualApi = (SubscriptionIndividualApi)TestUtil.getStoreApiClient((String)"user6", (String)TestUtil.getUser((String)"user6"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionIndividualApi.class);
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(3), Integer.valueOf(0), null, "", null);
        Assert.assertTrue((apiList.getCount() > 0 ? 1 : 0) != 0);
        APIInfo retrievedAPIInfo = null;
        for (APIInfo apiInfo : apiList.getList()) {
            if (!"restrictedapi1".equals(apiInfo.getName())) continue;
            retrievedAPIInfo = apiInfo;
            break;
        }
        Assert.assertNotNull(retrievedAPIInfo);
        Assert.assertEquals((Object)retrievedAPIInfo.getName(), (Object)"restrictedapi1");
        Assert.assertEquals((Object)retrievedAPIInfo.getVersion(), (Object)"1.0.0");
        Assert.assertEquals((Object)retrievedAPIInfo.getLifeCycleStatus(), (Object)"Published");
        Assert.assertEquals((Object)retrievedAPIInfo.getContext(), (Object)"/restrictedapi1/1.0.0");
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getStoreApiClient((String)"user6", (String)TestUtil.getUser((String)"user6"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        API api = apiIndividualApi.apisApiIdGet(retrievedAPIInfo.getId(), null, null);
        Assert.assertNotNull((Object)api);
        Application application = new Application().name("APIVisibilityTestCaseIT").throttlingTier("Unlimited");
        application = applicationIndividualApi.applicationsPost(application);
        this.applicationList.add(application);
        Subscription subscription = new Subscription().policy("Unlimited").applicationId(application.getApplicationId()).apiIdentifier(api.getId());
        subscriptionIndividualApi.subscriptionsPost(subscription);
    }

    @Test(description="user available in not restricted group", dependsOnMethods={"testAPIVisibleToUserInRestrictedGroup"})
    public void testAPIVisibleOnNotSelectedGroup() throws AMIntegrationTestException {
        APICollectionApi apiCollectionApi = (APICollectionApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        ApplicationIndividualApi applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        SubscriptionIndividualApi subscriptionIndividualApi = (SubscriptionIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(SubscriptionIndividualApi.class);
        APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(3), Integer.valueOf(0), null, "", null);
        Assert.assertTrue((apiList.getCount() > 0 ? 1 : 0) != 0);
        APIInfo retrievedAPIInfo = null;
        for (APIInfo apiInfo : apiList.getList()) {
            if (!"restrictedapi1".equals(apiInfo.getName())) continue;
            retrievedAPIInfo = apiInfo;
            break;
        }
        Assert.assertNull(retrievedAPIInfo);
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
        try {
            apiIndividualApi.apisApiIdGet(this.apiInfo.getId(), null, null);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RestAPIException));
            RestAPIException restAPIException = (RestAPIException)e.getCause();
            Assert.assertEquals((long)restAPIException.getCode(), (long)404L);
        }
        Application application = new Application().name("APIVisibilityTestCaseIT").throttlingTier("Unlimited");
        application = applicationIndividualApi.applicationsPost(application);
        this.applicationList.add(application);
        Subscription subscription = new Subscription().policy("Unlimited").applicationId(application.getApplicationId()).apiIdentifier(this.apiInfo.getId());
        try {
            subscriptionIndividualApi.subscriptionsPost(subscription);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RestAPIException));
            RestAPIException restAPIException = (RestAPIException)e.getCause();
            Assert.assertEquals((long)restAPIException.getCode(), (long)404L);
        }
    }

    @Test(description="user available in not restricted group", dependsOnMethods={"testAPIVisibleOnNotSelectedGroup"})
    public void testGetApiInAnonymousView() throws AMIntegrationTestException {
        APIIndividualApi apiIndividualApi = (APIIndividualApi)TestUtil.getStoreApiClientWithoutUser().buildClient(APIIndividualApi.class);
        try {
            apiIndividualApi.apisApiIdGet(this.apiInfo.getId(), "", "");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof RestAPIException));
            RestAPIException restAPIException = (RestAPIException)ex.getCause();
            Assert.assertEquals((long)restAPIException.getCode(), (long)404L);
        }
    }

    @AfterClass
    public void destroy() throws AMIntegrationTestException {
        for (Application application : this.applicationList) {
            ApplicationIndividualApi applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)application.getSubscriber(), (String)TestUtil.getUser((String)application.getSubscriber()), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
            applicationIndividualApi.applicationsApplicationIdDelete(application.getApplicationId(), "", "");
        }
    }
}

