/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.store;

import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.ApplicationIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeys;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationToken;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationTokenGenerateRequest;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class ApplicationJWTTestCaseIT {
    ApplicationIndividualApi applicationIndividualApi;
    Application application;

    @BeforeClass
    public void setUp() throws Exception {
        this.application = new Application().name("ApplicationJWTTestCaseIT").throttlingTier("Unlimited").description("this is ApplicationJWTTestCaseIT");
        this.applicationIndividualApi = (ApplicationIndividualApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(ApplicationIndividualApi.class);
        this.application = this.applicationIndividualApi.applicationsPost(this.application);
    }

    @Test
    public void testGenerateApplicationJWTToken() throws ParseException {
        ApplicationKeyGenerateRequest applicationKeyGenerateRequest = new ApplicationKeyGenerateRequest().grantTypesToBeSupported(Arrays.asList("client_credentials", "password")).tokenType(ApplicationKeyGenerateRequest.TokenTypeEnum.JWT).keyType(ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION);
        ApplicationKeys applicationKeys = this.applicationIndividualApi.applicationsApplicationIdGenerateKeysPost(this.application.getApplicationId(), applicationKeyGenerateRequest);
        Assert.assertEquals((String)applicationKeys.getTokenType().getValue(), (String)applicationKeyGenerateRequest.getTokenType().getValue());
        Assert.assertNotNull((Object)applicationKeys.getConsumerKey());
        Assert.assertNotNull((Object)applicationKeys.getConsumerSecret());
        ApplicationToken applicationToken = this.applicationIndividualApi.applicationsApplicationIdGenerateTokenPost(this.application.getApplicationId(), new ApplicationTokenGenerateRequest().consumerKey(applicationKeys.getConsumerKey()).consumerSecret(applicationKeys.getConsumerSecret()).scopes("default").validityPeriod(Integer.valueOf(3600)), "", "");
        Assert.assertNotNull((Object)applicationToken);
        Assert.assertNotNull((Object)applicationToken.getAccessToken());
        Assert.assertNotNull((Object)applicationToken.getTokenScopes());
        Assert.assertEquals((String)applicationToken.getTokenScopes(), (String)"default");
        Assert.assertTrue((applicationToken.getAccessToken().split("\\.").length > 1 ? 1 : 0) != 0);
        SignedJWT signedJWT = SignedJWT.parse((String)applicationToken.getAccessToken());
        ReadOnlyJWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
        Assert.assertTrue((boolean)jwtClaimsSet.getExpirationTime().after(jwtClaimsSet.getIssueTime()));
        Assert.assertEquals((String)jwtClaimsSet.getIssuer(), (String)"https://localhost:9443/oauth2/token");
        Assert.assertEquals((Collection)jwtClaimsSet.getAudience(), Arrays.asList("http://org.wso2.apimgt/gateway"));
        ApplicationKeys retrievedApplicationKeys = this.applicationIndividualApi.applicationsApplicationIdKeysKeyTypeGet(this.application.getApplicationId(), ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION.getValue());
        Assert.assertEquals((String)retrievedApplicationKeys.getConsumerKey(), (String)applicationKeys.getConsumerKey());
        Assert.assertEquals((String)retrievedApplicationKeys.getConsumerSecret(), (String)applicationKeys.getConsumerSecret());
        Assert.assertEquals((Object)retrievedApplicationKeys.getTokenType(), (Object)applicationKeys.getTokenType());
        retrievedApplicationKeys.setTokenType(ApplicationKeys.TokenTypeEnum.OAUTH);
        ApplicationKeys updatedApplicationKeys = this.applicationIndividualApi.applicationsApplicationIdKeysKeyTypePut(this.application.getApplicationId(), ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION.getValue(), retrievedApplicationKeys);
        Assert.assertEquals((String)updatedApplicationKeys.getConsumerKey(), (String)applicationKeys.getConsumerKey());
        Assert.assertEquals((String)updatedApplicationKeys.getConsumerSecret(), (String)applicationKeys.getConsumerSecret());
        Assert.assertEquals((String)updatedApplicationKeys.getTokenType().getValue(), (String)"OAUTH");
        ApplicationToken retrievedToken = this.applicationIndividualApi.applicationsApplicationIdGenerateTokenPost(this.application.getApplicationId(), new ApplicationTokenGenerateRequest().consumerKey(applicationKeys.getConsumerKey()).consumerSecret(applicationKeys.getConsumerSecret()).scopes("default").validityPeriod(Integer.valueOf(3600)), "", "");
        Assert.assertTrue((retrievedToken.getAccessToken().split("\\.").length <= 1 ? 1 : 0) != 0);
    }
}

