/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WorkflowRequest {
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="attributes")
    private Map<String, String> attributes = null;
    @JsonProperty(value="description")
    private String description = null;

    public WorkflowRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="APPROVED", required=true, value="This attribute declares whether this workflow task is approved or rejected. ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WorkflowRequest attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public WorkflowRequest putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes to complete the workflow task ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public WorkflowRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Approve workflow request.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRequest workflowRequest = (WorkflowRequest)o;
        return Objects.equals((Object)this.status, (Object)workflowRequest.status) && Objects.equals(this.attributes, workflowRequest.attributes) && Objects.equals(this.description, workflowRequest.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.attributes, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowRequest {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        APPROVED("APPROVED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

