/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.store.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicationKeys {
    @JsonProperty(value="consumerKey")
    private String consumerKey = null;
    @JsonProperty(value="consumerSecret")
    private String consumerSecret = null;
    @JsonProperty(value="supportedGrantTypes")
    private List<String> supportedGrantTypes = null;
    @JsonProperty(value="callbackUrl")
    private String callbackUrl = null;
    @JsonProperty(value="keyType")
    private KeyTypeEnum keyType = null;
    @JsonProperty(value="tokenType")
    private TokenTypeEnum tokenType = TokenTypeEnum.OAUTH;

    public ApplicationKeys consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    @ApiModelProperty(value="Consumer key of the application")
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public ApplicationKeys consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    @ApiModelProperty(value="Consumer secret of the application")
    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public ApplicationKeys supportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public ApplicationKeys addSupportedGrantTypesItem(String supportedGrantTypesItem) {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new ArrayList<String>();
        }
        this.supportedGrantTypes.add(supportedGrantTypesItem);
        return this;
    }

    @ApiModelProperty(value="Supported grant types for the application")
    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public void setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    public ApplicationKeys callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @ApiModelProperty(value="Callback URL")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApplicationKeys keyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(value="Key type")
    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public ApplicationKeys tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(example="OAUTH", value="Type of the access token generated for this application.  **OAUTH:** A UUID based access token which is issued by default. **JWT:** A self-contained, signed JWT based access token. **Note:** This can be only used in Microgateway environments. ")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeys applicationKeys = (ApplicationKeys)o;
        return Objects.equals(this.consumerKey, applicationKeys.consumerKey) && Objects.equals(this.consumerSecret, applicationKeys.consumerSecret) && Objects.equals(this.supportedGrantTypes, applicationKeys.supportedGrantTypes) && Objects.equals(this.callbackUrl, applicationKeys.callbackUrl) && Objects.equals((Object)this.keyType, (Object)applicationKeys.keyType) && Objects.equals((Object)this.tokenType, (Object)applicationKeys.tokenType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consumerKey, this.consumerSecret, this.supportedGrantTypes, this.callbackUrl, this.keyType, this.tokenType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeys {\n");
        sb.append("    consumerKey: ").append(this.toIndentedString(this.consumerKey)).append("\n");
        sb.append("    consumerSecret: ").append(this.toIndentedString(this.consumerSecret)).append("\n");
        sb.append("    supportedGrantTypes: ").append(this.toIndentedString(this.supportedGrantTypes)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString((Object)this.keyType)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenTypeEnum {
        OAUTH("OAUTH"),
        JWT("JWT");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenTypeEnum fromValue(String text) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum KeyTypeEnum {
        PRODUCTION("PRODUCTION"),
        SANDBOX("SANDBOX");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeyTypeEnum fromValue(String text) {
            for (KeyTypeEnum b : KeyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

