/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util.auth;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.RetryableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TokenInfo;

public class OAuth
implements RequestInterceptor {
    private static Logger log = LoggerFactory.getLogger(OAuth.class);
    private String username;
    private String password;
    private String scopes;

    public OAuth(String username, String password, String scopes) {
        this.username = username;
        this.password = password;
        this.scopes = scopes;
    }

    public void apply(RequestTemplate template) {
        if (template.headers().containsKey("Authorization")) {
            return;
        }
        TokenInfo tokenInfo = this.generateFirstToken();
        if (tokenInfo != null) {
            template.header("Authorization", new String[]{"Bearer " + tokenInfo.getToken()});
        }
    }

    public TokenInfo generateFirstToken() {
        try {
            log.info("Generate Token for user:" + this.username);
            return TestUtil.generateToken(this.username, this.password, this.scopes);
        }
        catch (Exception e) {
            throw new RetryableException(e.getMessage(), (Throwable)e, null);
        }
    }
}

