/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.ProgressResponseBody;
import org.wso2.carbon.apimgt.rest.integration.tests.model.Tier;
import org.wso2.carbon.apimgt.rest.integration.tests.model.TierPermission;

public class ThrottlingTierIndividualApi {
    private ApiClient apiClient;

    public ThrottlingTierIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThrottlingTierIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call policiesTierLevelTierNameDeleteCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/policies/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesTierLevelTierNameDeleteValidateBeforeCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling policiesTierLevelTierNameDelete(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesTierLevelTierNameDelete(Async)");
        }
        Call call = this.policiesTierLevelTierNameDeleteCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void policiesTierLevelTierNameDelete(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.policiesTierLevelTierNameDeleteWithHttpInfo(tierName, tierLevel, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> policiesTierLevelTierNameDeleteWithHttpInfo(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.policiesTierLevelTierNameDeleteValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call policiesTierLevelTierNameDeleteAsync(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesTierLevelTierNameDeleteValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call policiesTierLevelTierNameGetCall(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/policies/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesTierLevelTierNameGetValidateBeforeCall(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling policiesTierLevelTierNameGet(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesTierLevelTierNameGet(Async)");
        }
        Call call = this.policiesTierLevelTierNameGetCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Tier policiesTierLevelTierNameGet(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<Tier> resp = this.policiesTierLevelTierNameGetWithHttpInfo(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<Tier> policiesTierLevelTierNameGetWithHttpInfo(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.policiesTierLevelTierNameGetValidateBeforeCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call policiesTierLevelTierNameGetAsync(String tierName, String tierLevel, String accept, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Tier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesTierLevelTierNameGetValidateBeforeCall(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call policiesTierLevelTierNamePutCall(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Tier localVarPostBody = body;
        String localVarPath = "/policies/{tierLevel}/{tierName}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierName\\}", this.apiClient.escapeString(tierName.toString())).replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesTierLevelTierNamePutValidateBeforeCall(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling policiesTierLevelTierNamePut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling policiesTierLevelTierNamePut(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesTierLevelTierNamePut(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling policiesTierLevelTierNamePut(Async)");
        }
        Call call = this.policiesTierLevelTierNamePutCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public Tier policiesTierLevelTierNamePut(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<Tier> resp = this.policiesTierLevelTierNamePutWithHttpInfo(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<Tier> policiesTierLevelTierNamePutWithHttpInfo(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.policiesTierLevelTierNamePutValidateBeforeCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call policiesTierLevelTierNamePutAsync(String tierName, Tier body, String tierLevel, String contentType, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Tier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesTierLevelTierNamePutValidateBeforeCall(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call policiesUpdatePermissionPostCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TierPermission localVarPostBody = permissions;
        String localVarPath = "/policies/update-permission".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (tierName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tierName", tierName));
        }
        if (tierLevel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tierLevel", tierLevel));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesUpdatePermissionPostValidateBeforeCall(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierName == null) {
            throw new ApiException("Missing the required parameter 'tierName' when calling policiesUpdatePermissionPost(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesUpdatePermissionPost(Async)");
        }
        Call call = this.policiesUpdatePermissionPostCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, progressListener, progressRequestListener);
        return call;
    }

    public List<Tier> policiesUpdatePermissionPost(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions) throws ApiException {
        ApiResponse<List<Tier>> resp = this.policiesUpdatePermissionPostWithHttpInfo(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions);
        return resp.getData();
    }

    public ApiResponse<List<Tier>> policiesUpdatePermissionPostWithHttpInfo(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions) throws ApiException {
        Call call = this.policiesUpdatePermissionPostValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, null, null);
        Type localVarReturnType = new TypeToken<List<Tier>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call policiesUpdatePermissionPostAsync(String tierName, String tierLevel, String ifMatch, String ifUnmodifiedSince, TierPermission permissions, final ApiCallback<List<Tier>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesUpdatePermissionPostValidateBeforeCall(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Tier>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

