/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.framework.extensions;

import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.extensions.servers.carbonserver.CarbonServerExtension;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.carbon.integration.common.utils.FileManager;

public class APIMCarbonServerExtension
extends ExecutionListenerExtension {
    private static final Log log = LogFactory.getLog(CarbonServerExtension.class);
    private TestServerManager serverManager;
    private String executionEnvironment;

    public void initiate() {
        this.configureProduct();
        try {
            if (this.getParameters().get("-DportOffset") == null) {
                this.getParameters().put("-DportOffset", "0");
            }
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            APIMCarbonServerExtension.handleException("Error while initiating test environment", e);
        }
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = this.serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            APIMCarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                this.serverManager.stopServer();
            }
        }
        catch (Exception e) {
            APIMCarbonServerExtension.handleException("Fail to stop carbon server ", e);
        }
    }

    private void configureProduct() {
        this.getParameters().put("-DosgiConsole", "2000");
        this.serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters()){

            public void configureServer() throws AutomationFrameworkException {
                String resourcePath = APIMCarbonServerExtension.this.getAMResourceLocation();
                try {
                    FileManager.copyFile((File)new File(resourcePath + File.separator + "configFiles" + File.separator + "throttling" + File.separator + "jndi.properties"), (String)(APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "jndi.properties"));
                }
                catch (IOException e) {
                    throw new AutomationFrameworkException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private String getAMResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM";
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

