/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.framework.extensions;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.extensions.servers.carbonserver.CarbonServerExtension;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;

public class APIMUnzipCarbonServerExtension
extends ExecutionListenerExtension {
    private static final Log log = LogFactory.getLog(CarbonServerExtension.class);
    private TestServerManager serverManager;
    private String executionEnvironment;

    public void initiate() {
        if (this.getParameters().get("-DportOffset") == null) {
            this.getParameters().put("-DportOffset", "0");
        }
        try {
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            APIMUnzipCarbonServerExtension.handleException("Error while initiating test environment", e);
        }
        this.configureProduct();
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = this.serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            APIMUnzipCarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
    }

    private void configureProduct() {
        this.serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters()){

            public String startServer() throws AutomationFrameworkException, IOException {
                if (this.carbonHome == null) {
                    if (this.carbonZip == null) {
                        this.carbonZip = System.getProperty("carbon.zip");
                    }
                    if (this.carbonZip == null) {
                        throw new IllegalArgumentException("carbon zip file cannot find in the given location");
                    }
                    this.carbonHome = this.carbonServer.setUpCarbonHome(this.carbonZip);
                    this.configureServer();
                }
                log.info((Object)("Carbon Home - " + this.carbonHome));
                return this.carbonHome;
            }
        };
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

