/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.framework.extensions;

import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.carbon.integration.common.utils.FileManager;

public class APIMCarbonServerExtension
extends ExecutionListenerExtension {
    private static final Log log = LogFactory.getLog(APIMCarbonServerExtension.class);
    private TestServerManager serverManager;
    private String executionEnvironment;
    private static final String CUSTOM_AUTH_HANDLER_JAR = "CustomAPIAuthenticationHandler-1.0.0.jar";
    protected static final String CARBON_HOME = FrameworkPathUtil.getCarbonHome();

    public void initiate() {
        this.configureProduct();
        try {
            if (this.getParameters().get("-DportOffset") == null) {
                this.getParameters().put("-DportOffset", "0");
            }
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            APIMCarbonServerExtension.handleException("Error while initiating test environment", e);
        }
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = this.serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            APIMCarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                this.serverManager.stopServer();
            }
        }
        catch (Exception e) {
            APIMCarbonServerExtension.handleException("Fail to stop carbon server ", e);
        }
    }

    private void configureProduct() {
        this.getParameters().put("-DosgiConsole", "2000");
        this.serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters()){

            public String startServer() throws AutomationFrameworkException, IOException, XPathExpressionException {
                return super.startServer();
            }

            public void configureServer() throws AutomationFrameworkException {
                String resourcePath = APIMCarbonServerExtension.this.getAMResourceLocation();
                String relativeResourcePath = File.separator + "artifacts" + File.separator + "AM";
                try {
                    String customHandlerTargetPath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "components" + File.separator + "lib";
                    String dropinsPath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "components" + File.separator + "dropins";
                    String webappsPath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "webapps" + File.separator;
                    String synapseApiPath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "synapse-configs" + File.separator + "default" + File.separator + "api";
                    FileManager.copyFile((File)new File(resourcePath + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "BackEndSecurity.xml"), (String)(synapseApiPath + File.separator + "BackEndSecurity.xml"));
                    FileManager.copyFile((File)new File(resourcePath + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "JWKS-Backend.xml"), (String)(synapseApiPath + File.separator + "JWKS-Backend.xml"));
                    String userStorePath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "userstores";
                    String databasePath = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "database";
                    FileManager.copyFile((File)new File(resourcePath + File.separator + "configFiles" + File.separator + "originalFile" + File.separator + "deployment.toml"), (String)(APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "deployment.toml"));
                    File userStoreFile = new File(userStorePath);
                    if (!userStoreFile.exists() && !userStoreFile.mkdir()) {
                        log.error((Object)("Error while creating the user store directory : " + userStorePath));
                    }
                    FileUtils.copyFile((File)new File(resourcePath + File.separator + "configFiles" + File.separator + "userstores" + File.separator + "database" + File.separator + "WSO2SEC_DB.mv.db"), (File)new File(databasePath + File.separator + "WSO2SEC_DB.mv.db"));
                    FileManager.copyFile((File)new File(resourcePath + File.separator + "configFiles" + File.separator + "userstores" + File.separator + "secondary.xml"), (String)(userStorePath + File.separator + "secondary.xml"));
                    FileManager.copyJarFile((File)new File(APIMCarbonServerExtension.this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "APIM5898" + File.separator + "subs-workflow-1.0.0.jar"), (String)customHandlerTargetPath);
                    String apimVersion = System.getProperty("apim.server.version");
                    FileManager.copyJarFile((File)new File(APIMCarbonServerExtension.this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "idpjwt" + File.separator + "org.wso2.am.thirdparty.km-" + apimVersion + ".jar"), (String)dropinsPath);
                    String customHandlerSourcePath = APIMCarbonServerExtension.this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + APIMCarbonServerExtension.CUSTOM_AUTH_HANDLER_JAR;
                    FileManager.copyJarFile((File)new File(customHandlerSourcePath), (String)customHandlerTargetPath);
                    String log4jPropertiesFile = APIMCarbonServerExtension.this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "log4j2.properties";
                    String log4jPropertiesTargetLocation = APIMCarbonServerExtension.this.serverManager.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "log4j2.properties";
                    FileManager.copyFile((File)new File(log4jPropertiesFile), (String)log4jPropertiesTargetLocation);
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "jaxrs_basic" + ".war"), (String)(webappsPath + "jaxrs_basic"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-check1" + ".war"), (String)(webappsPath + "name-check1"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-checkOne" + ".war"), (String)(webappsPath + "name-checkOne"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-checkTwo" + ".war"), (String)(webappsPath + "name-checkTwo"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-checkThree" + ".war"), (String)(webappsPath + "name-checkThree"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-check1_SB" + ".war"), (String)(webappsPath + "name-check1_SB"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-check2_SB" + ".war"), (String)(webappsPath + "name-check2_SB"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "name-check3_SB" + ".war"), (String)(webappsPath + "name-check3_SB"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "wildcard" + ".war"), (String)(webappsPath + "wildcard"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "APIStatusMonitor" + ".war"), (String)(webappsPath + "APIStatusMonitor"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "am-graphQL-sample" + ".war"), (String)(webappsPath + "am-graphQL-sample"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "am-auditApi-sample" + ".war"), (String)(webappsPath + "am-auditApi-sample"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "etcdmock" + ".war"), (String)(webappsPath + "etcdmock"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "duplicate-header-backend" + ".war"), (String)(webappsPath + "duplicate-header-backend"));
                    WebAppDeploymentUtil.copyWebApp((String)(relativeResourcePath + File.separator + "war" + File.separator + "BPMNProcessServerApp-1.0.0" + ".war"), (String)(webappsPath + "BPMNProcessServerApp-1.0.0"));
                    log.info((Object)"Web Apps Deployed");
                }
                catch (IOException e) {
                    throw new AutomationFrameworkException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private String getAMResourceLocation() {
        return FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM";
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

