/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.proxy.admin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminProxyAdminException;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminStub;
import org.wso2.carbon.proxyadmin.stub.types.carbon.Entry;
import org.wso2.carbon.proxyadmin.stub.types.carbon.ProxyData;
import org.wso2.carbon.proxyadmin.stub.types.carbon.ProxyServicePolicyInfo;

public class ProxyServiceAdminClient {
    private static final Log log = LogFactory.getLog(ProxyServiceAdminClient.class);
    private ProxyServiceAdminStub proxyServiceAdminStub;
    private final String serviceName = "ProxyServiceAdmin";

    public ProxyServiceAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "ProxyServiceAdmin";
        this.proxyServiceAdminStub = new ProxyServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.proxyServiceAdminStub);
    }

    public ProxyServiceAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "ProxyServiceAdmin";
        this.proxyServiceAdminStub = new ProxyServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.proxyServiceAdminStub);
    }

    public void addProxyService(String proxyName, String wsdlURI, String serviceEndPoint) throws Exception {
        String[] transport = new String[]{"http", "https"};
        ProxyData data = new ProxyData();
        data.setName(proxyName);
        data.setWsdlURI(wsdlURI);
        data.setTransports(transport);
        data.setStartOnLoad(true);
        data.setEndpointXML("<endpoint xmlns=\"http://ws.apache.org/ns/synapse\"><address uri=\"" + serviceEndPoint + "\" /></endpoint>");
        data.setEnableSecurity(true);
        try {
            this.proxyServiceAdminStub.addProxy(data);
        }
        catch (Exception e) {
            throw new Exception("Error while adding proxy ", e);
        }
        log.info((Object)"Proxy Added");
    }

    public void addProxyService(DataHandler dh) throws ProxyServiceAdminProxyAdminException, IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement documentElement = builder.getDocumentElement();
        ProxyData proxyData = this.getProxyData(documentElement.toString());
        log.info((Object)"Proxy Added");
    }

    public void addProxyService(OMElement data) throws Exception {
        ProxyData proxyData = this.getProxyData(data.toString());
        try {
            this.proxyServiceAdminStub.addProxy(proxyData);
        }
        catch (Exception e) {
            throw new Exception("Error while adding proxy ", e);
        }
        log.info((Object)"Proxy Added");
    }

    public void deleteProxy(String proxyName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        AuthenticateStub auth = new AuthenticateStub();
        this.proxyServiceAdminStub.deleteProxyService(proxyName);
        log.info((Object)"Proxy Deleted");
    }

    public void stopProxyService(String proxyName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        this.proxyServiceAdminStub.stopProxyService(proxyName);
        log.info((Object)"Proxy Deactivated");
    }

    public void reloadProxyService(String proxyName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        this.proxyServiceAdminStub.redeployProxyService(proxyName);
        log.info((Object)"Proxy Redeployed");
    }

    public ProxyData getProxyDetails(String proxyName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        return this.proxyServiceAdminStub.getProxy(proxyName);
    }

    public ProxyData getProxyData(String proxyString) {
        String BUNDLE = "org.wso2.carbon.proxyadmin.Resources";
        ProxyData pd = new ProxyData();
        ResourceBundle bundle = ResourceBundle.getBundle("org.wso2.carbon.proxyadmin.Resources", Locale.US);
        try {
            OMElement description;
            OMElement enableSec;
            String val;
            OMAttribute startOnLoad;
            String traceValue;
            OMAttribute trace;
            String[] arr;
            String pinnedServersValue;
            OMAttribute pinnedServers;
            String[] arr2;
            String transports;
            OMAttribute trans;
            String statisticsValue;
            OMAttribute statistics;
            OMAttribute name;
            byte[] bytes = null;
            try {
                bytes = proxyString.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
                bytes = proxyString.getBytes();
            }
            OMElement elem = new StAXOMBuilder((InputStream)new ByteArrayInputStream(bytes)).getDocumentElement();
            Iterator itr = elem.getAllDeclaredNamespaces();
            boolean synapseNSPresent = false;
            while (itr.hasNext()) {
                OMNamespace ns = (OMNamespace)itr.next();
                if (!"http://ws.apache.org/ns/synapse".equals(ns.getNamespaceURI())) continue;
                synapseNSPresent = true;
                break;
            }
            if ((name = elem.getAttribute(new QName("name"))) != null) {
                pd.setName(name.getAttributeValue());
            }
            if ((statistics = elem.getAttribute(new QName("statistics"))) != null && (statisticsValue = statistics.getAttributeValue()) != null) {
                if ("enable".equals(statisticsValue)) {
                    pd.setEnableStatistics(true);
                } else if ("disable".equals(statisticsValue)) {
                    pd.setEnableStatistics(false);
                }
            }
            if ((trans = elem.getAttribute(new QName("transports"))) != null && (transports = trans.getAttributeValue()) != null && !"".equals(transports) && !"all".equals(transports) && (arr2 = transports.split(",")) != null && arr2.length != 0) {
                pd.setTransports(arr2);
            }
            if ((pinnedServers = elem.getAttribute(new QName("pinnedServers"))) != null && (pinnedServersValue = pinnedServers.getAttributeValue()) != null && !"".equals(pinnedServersValue) && (arr = pinnedServersValue.split(",")) != null && arr.length != 0) {
                pd.setPinnedServers(arr);
            }
            if ((trace = elem.getAttribute(new QName("trace"))) != null && (traceValue = trace.getAttributeValue()) != null) {
                if (traceValue.equals("enable")) {
                    pd.setEnableTracing(true);
                } else if (traceValue.equals("disable")) {
                    pd.setEnableTracing(false);
                }
            }
            if ((startOnLoad = elem.getAttribute(new QName("startOnLoad"))) != null && (val = startOnLoad.getAttributeValue()) != null && !"".equals(val)) {
                pd.setStartOnLoad(Boolean.valueOf(val).booleanValue());
            } else {
                pd.setStartOnLoad(true);
            }
            OMElement target = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "target"));
            if (target != null) {
                OMAttribute inSequence = target.getAttribute(new QName("inSequence"));
                if (inSequence != null) {
                    pd.setInSeqKey(inSequence.getAttributeValue());
                } else {
                    OMElement inSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "inSequence"));
                    if (inSequenceElement != null) {
                        pd.setInSeqXML(inSequenceElement.toString());
                    }
                }
                OMAttribute outSequence = target.getAttribute(new QName("outSequence"));
                if (outSequence != null) {
                    pd.setOutSeqKey(outSequence.getAttributeValue());
                } else {
                    OMElement outSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "outSequence"));
                    if (outSequenceElement != null) {
                        pd.setOutSeqXML(outSequenceElement.toString());
                    }
                }
                OMAttribute faultSequence = target.getAttribute(new QName("faultSequence"));
                if (faultSequence != null) {
                    pd.setFaultSeqKey(faultSequence.getAttributeValue());
                } else {
                    OMElement faultSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "faultSequence"));
                    if (faultSequenceElement != null) {
                        pd.setFaultSeqXML(faultSequenceElement.toString());
                    }
                }
                OMAttribute tgtEndpt = target.getAttribute(new QName("endpoint"));
                if (tgtEndpt != null) {
                    pd.setEndpointKey(tgtEndpt.getAttributeValue());
                } else {
                    OMElement endpointElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
                    if (endpointElement != null) {
                        pd.setEndpointXML(endpointElement.toString());
                    }
                }
            }
            Iterator props = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
            ArrayList<Entry> params = new ArrayList<Entry>();
            Entry entry = null;
            while (props.hasNext()) {
                Object o = props.next();
                if (!(o instanceof OMElement)) continue;
                OMElement prop = (OMElement)o;
                OMAttribute pname = prop.getAttribute(new QName("name"));
                OMElement propertyValue = prop.getFirstElement();
                if (pname == null) continue;
                if (propertyValue != null) {
                    entry = new Entry();
                    entry.setKey(pname.getAttributeValue());
                    entry.setValue(propertyValue.toString());
                    params.add(entry);
                    continue;
                }
                entry = new Entry();
                entry.setKey(pname.getAttributeValue());
                entry.setValue(prop.getText().trim());
                params.add(entry);
            }
            pd.setServiceParams(params.toArray(new Entry[params.size()]));
            OMElement wsdl = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "publishWSDL"));
            if (wsdl != null) {
                OMAttribute wsdlkey = wsdl.getAttribute(new QName("", "key"));
                OMAttribute wsdlEP = wsdl.getAttribute(new QName("", "endpoint"));
                if (wsdlEP == null) {
                    if (wsdlkey != null) {
                        pd.setWsdlKey(wsdlkey.getAttributeValue());
                    } else {
                        OMAttribute wsdlURI = wsdl.getAttribute(new QName("", "uri"));
                        if (wsdlURI != null) {
                            pd.setWsdlURI(wsdlURI.getAttributeValue());
                        } else {
                            String wsdlDef;
                            OMElement wsdl11 = wsdl.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
                            if (wsdl11 != null) {
                                wsdlDef = wsdl11.toString().replaceAll("\n|\\r|\\f|\\t", "");
                                wsdlDef = wsdlDef.replaceAll("> +<", "><");
                                pd.setWsdlDef(wsdlDef);
                            } else {
                                OMElement wsdl20 = wsdl.getFirstChildWithName(new QName("http://www.w3.org/ns/wsdl", "description"));
                                if (wsdl20 != null) {
                                    wsdlDef = wsdl20.toString().replaceAll("\n|\\r|\\f|\\t", "");
                                    wsdlDef = wsdlDef.replaceAll("> +<", "><");
                                    pd.setWsdlDef(wsdlDef);
                                }
                            }
                        }
                    }
                }
                Iterator it = wsdl.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "resource"));
                ArrayList<Entry> resources = new ArrayList<Entry>();
                Entry resource = null;
                while (it.hasNext()) {
                    OMElement resourceElem = (OMElement)it.next();
                    OMAttribute location = resourceElem.getAttribute(new QName("", "location"));
                    if (location == null) {
                        throw new XMLStreamException("location element not found in xml file");
                    }
                    OMAttribute key = resourceElem.getAttribute(new QName("", "key"));
                    if (key == null) {
                        throw new XMLStreamException("key element not found in xml file");
                    }
                    resource = new Entry();
                    resource.setKey(location.getAttributeValue());
                    resource.setValue(key.getAttributeValue());
                    resources.add(resource);
                }
                pd.setWsdlResources(resources.toArray(new Entry[resources.size()]));
            }
            if ((enableSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
                pd.setEnableSecurity(true);
            }
            if ((description = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "description"))) != null) {
                pd.setDescription(description.getText());
            }
            Iterator policies = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "policy"));
            while (policies.hasNext()) {
                OMElement policyElement = (OMElement)policies.next();
                String policyKey = policyElement.getAttributeValue(new QName("key"));
                ProxyServicePolicyInfo policyInfo = new ProxyServicePolicyInfo();
                policyInfo.setKey(policyKey);
                pd.addPolicies(policyInfo);
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)bundle.getString("unable.to.build.the.design.view.from.the.given.xml"), (Throwable)e);
            Assert.fail((String)bundle.getString("unable.to.build.the.design.view.from.the.given.xml"));
        }
        return pd;
    }

    public void updateProxy(OMElement data) throws ProxyServiceAdminProxyAdminException, RemoteException {
        ProxyData proxyData = this.getProxyData(data.toString());
        this.proxyServiceAdminStub.modifyProxy(proxyData);
        log.info((Object)"Proxy Updated");
    }

    public void updateProxy(ProxyData proxyData) throws ProxyServiceAdminProxyAdminException, RemoteException {
        this.proxyServiceAdminStub.modifyProxy(proxyData);
        log.info((Object)"Proxy Updated");
    }
}

