/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.webapp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.wso2.carbon.integration.common.admin.client.utils.AuthenticateStubUtil;
import org.wso2.carbon.webapp.mgt.stub.WebappAdminStub;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.VersionedWebappMetadata;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.WebappMetadata;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.WebappUploadData;
import org.wso2.carbon.webapp.mgt.stub.types.carbon.WebappsWrapper;

public class WebAppAdminClient {
    private WebappAdminStub webappAdminStub;

    public WebAppAdminClient(String backendUrl, String sessionCookie) throws AxisFault {
        String serviceName = "WebappAdmin";
        String endPoint = backendUrl + serviceName;
        this.webappAdminStub = new WebappAdminStub(endPoint);
        AuthenticateStubUtil.authenticateStub((String)sessionCookie, (Stub)this.webappAdminStub);
    }

    public boolean uploadWarFile(String filePath) throws RemoteException, MalformedURLException {
        File file = new File(filePath);
        String fileName = file.getName();
        URL url = new URL("file://" + filePath);
        DataHandler dh = new DataHandler(url);
        WebappUploadData webApp = new WebappUploadData();
        webApp.setFileName(fileName);
        webApp.setDataHandler(dh);
        return this.webappAdminStub.uploadWebapp(new WebappUploadData[]{webApp});
    }

    public WebappsWrapper getPagedWebAppsSummary(String searchString, String webAppType, String webAppState, int pageNo) throws RemoteException {
        return this.webappAdminStub.getPagedWebappsSummary(searchString, webAppType, webAppState, pageNo);
    }

    public List<String> getWebAppList(String webAppNameSearchString) throws RemoteException {
        ArrayList<String> list = new ArrayList<String>();
        WebappsWrapper wrapper = this.getPagedWebAppsSummary(webAppNameSearchString, "ALL", "ALL", 0);
        VersionedWebappMetadata[] webAppGroups = wrapper.getWebapps();
        if (webAppGroups != null) {
            for (VersionedWebappMetadata webAppGroup : webAppGroups) {
                for (WebappMetadata metaData : webAppGroup.getVersionGroups()) {
                    list.add(metaData.getWebappFile());
                }
            }
        }
        return list;
    }

    public WebappsWrapper getPagedFaultyWebAppsSummary(String searchString, String webAppType, int pageNo) throws RemoteException {
        return this.webappAdminStub.getPagedFaultyWebappsSummary(searchString, webAppType, pageNo);
    }

    public List<String> getFaultyWebAppList(String webAppNameSearchString) throws RemoteException {
        ArrayList<String> list = new ArrayList<String>();
        WebappsWrapper wrapper = this.getPagedFaultyWebAppsSummary(webAppNameSearchString, "ALL", 0);
        VersionedWebappMetadata[] webAppGroups = wrapper.getWebapps();
        if (webAppGroups != null && webAppGroups[0].getVersionGroups() != null) {
            for (WebappMetadata metaData : webAppGroups[0].getVersionGroups()) {
                list.add(metaData.getWebappFile());
            }
        }
        return list;
    }
}

