/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.template;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.mediation.templates.endpoint.stub.types.EndpointTemplateAdminServiceStub;
import org.wso2.carbon.mediation.templates.endpoint.stub.types.common.EndpointTemplateInfo;

public class EndpointTemplateAdminServiceClient {
    private static final Log log = LogFactory.getLog(EndpointTemplateAdminServiceClient.class);
    private final String serviceName = "EndpointTemplateAdminService";
    private EndpointTemplateAdminServiceStub endpointTemplateAdminStub;

    public EndpointTemplateAdminServiceClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "EndpointTemplateAdminService";
        this.endpointTemplateAdminStub = new EndpointTemplateAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.endpointTemplateAdminStub);
    }

    public EndpointTemplateAdminServiceClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "EndpointTemplateAdminService";
        this.endpointTemplateAdminStub = new EndpointTemplateAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.endpointTemplateAdminStub);
    }

    public void addEndpointTemplate(OMElement endpointTemplate) throws RemoteException {
        this.endpointTemplateAdminStub.addEndpointTemplate(endpointTemplate.toString());
    }

    public void addEndpointTemplate(DataHandler dh) throws IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement endpointTemplate = builder.getDocumentElement();
        this.endpointTemplateAdminStub.addEndpointTemplate(endpointTemplate.toString());
    }

    public void addDynamicEndpointTemplate(String key, OMElement endpointTemplate) throws RemoteException {
        this.endpointTemplateAdminStub.addDynamicEndpointTemplate(key, endpointTemplate.toString());
    }

    public void addDynamicEndpointTemplate(String key, DataHandler dh) throws IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement endpointTemplate = builder.getDocumentElement();
        this.endpointTemplateAdminStub.addDynamicEndpointTemplate(key, endpointTemplate.toString());
    }

    public void deleteEndpointTemplate(String templateName) throws RemoteException {
        this.endpointTemplateAdminStub.deleteEndpointTemplate(templateName);
    }

    public void deleteDynamicEndpointTemplate(String key) throws RemoteException {
        this.endpointTemplateAdminStub.deleteDynamicEndpointTemplate(key);
    }

    public int getDynamicEndpointTemplatesCount() throws RemoteException {
        return this.endpointTemplateAdminStub.getDynamicEndpointTemplatesCount();
    }

    public int getEndpointTemplatesCount() throws RemoteException {
        return this.endpointTemplateAdminStub.getEndpointTemplatesCount();
    }

    public String[] getEndpointTemplates() throws RemoteException {
        EndpointTemplateInfo[] info = this.endpointTemplateAdminStub.getEndpointTemplates(0, 200);
        if (info == null || info.length == 0) {
            return null;
        }
        String[] templates = new String[info.length];
        int i = 0;
        for (EndpointTemplateInfo tmpInfo : info) {
            templates[i++] = tmpInfo.getTemplateName();
        }
        return templates;
    }
}

