/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.registry;

import java.rmi.RemoteException;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.registry.info.stub.RegistryExceptionException;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceExceptionException;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceResourceServiceExceptionException;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceStub;
import org.wso2.carbon.registry.resource.stub.beans.xsd.CollectionContentBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ContentBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ContentDownloadBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.MetadataBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.PermissionBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ResourceTreeEntryBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.VersionPath;
import org.wso2.carbon.registry.resource.stub.beans.xsd.VersionsBean;
import org.wso2.carbon.registry.resource.stub.common.xsd.ResourceData;

public class ResourceAdminServiceClient {
    private static final Log log = LogFactory.getLog(ResourceAdminServiceClient.class);
    private final String serviceName = "ResourceAdminService";
    private ResourceAdminServiceStub resourceAdminServiceStub;
    private static final String MEDIA_TYPE_WSDL = "application/wsdl+xml";
    private static final String MEDIA_TYPE_WADL = "application/wadl+xml";
    private static final String MEDIA_TYPE_SCHEMA = "application/x-xsd+xml";
    private static final String MEDIA_TYPE_POLICY = "application/policy+xml";
    private static final String MEDIA_TYPE_GOVERNANCE_ARCHIVE = "application/vnd.wso2.governance-archive";

    public ResourceAdminServiceClient(String serviceUrl, String sessionCookie) throws AxisFault {
        String endPoint = serviceUrl + "ResourceAdminService";
        this.resourceAdminServiceStub = new ResourceAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.resourceAdminServiceStub);
    }

    public ResourceAdminServiceClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "ResourceAdminService";
        this.resourceAdminServiceStub = new ResourceAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.resourceAdminServiceStub);
    }

    public boolean addResource(String destinationPath, String mediaType, String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destination Path :" + destinationPath));
            log.debug((Object)("Media Type :" + mediaType));
        }
        return this.resourceAdminServiceStub.addResource(destinationPath, mediaType, description, dh, null, null);
    }

    public ResourceData[] getResource(String destinationPath) throws ResourceAdminServiceExceptionException, RemoteException {
        ResourceData[] rs = this.resourceAdminServiceStub.getResourceData(new String[]{destinationPath});
        return rs;
    }

    public CollectionContentBean getCollectionContent(String destinationPath) throws RemoteException, ResourceAdminServiceExceptionException {
        CollectionContentBean collectionContentBean;
        try {
            collectionContentBean = this.resourceAdminServiceStub.getCollectionContent(destinationPath);
        }
        catch (RemoteException e) {
            log.error((Object)("Resource getting failed due to RemoteException : " + e));
            throw new RemoteException("Resource getting failed due to RemoteException :", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Resource getting failed due to ResourceAdminServiceExceptionException : ", (Throwable)e);
            throw new ResourceAdminServiceExceptionException("Resource getting failed due to ResourceAdminServiceExceptionException:", (Throwable)e);
        }
        return collectionContentBean;
    }

    public boolean deleteResource(String destinationPath) throws ResourceAdminServiceExceptionException, RemoteException {
        return this.resourceAdminServiceStub.delete(destinationPath);
    }

    public void addWSDL(String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        String fileName = dh.getName().substring(dh.getName().lastIndexOf(47) + 1);
        log.debug((Object)fileName);
        this.resourceAdminServiceStub.addResource("/" + fileName, MEDIA_TYPE_WSDL, description, dh, null, null);
    }

    public void addWADL(String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        String fileName = dh.getName().substring(dh.getName().lastIndexOf(47) + 1);
        log.debug((Object)fileName);
        this.resourceAdminServiceStub.addResource("/" + fileName, MEDIA_TYPE_WADL, description, dh, null, null);
    }

    public void addSchema(String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        String fileName = dh.getName().substring(dh.getName().lastIndexOf(47) + 1);
        this.resourceAdminServiceStub.addResource("/" + fileName, MEDIA_TYPE_SCHEMA, description, dh, null, null);
    }

    public void addPolicy(String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        String fileName = dh.getName().substring(dh.getName().lastIndexOf(47) + 1);
        this.resourceAdminServiceStub.addResource("/" + fileName, MEDIA_TYPE_POLICY, description, dh, null, null);
    }

    public void uploadArtifact(String description, DataHandler dh) throws ResourceAdminServiceExceptionException, RemoteException {
        String fileName = dh.getName().substring(dh.getName().lastIndexOf(47) + 1);
        this.resourceAdminServiceStub.addResource("/" + fileName, MEDIA_TYPE_GOVERNANCE_ARCHIVE, description, dh, null, null);
    }

    public String addCollection(String parentPath, String collectionName, String mediaType, String description) throws ResourceAdminServiceExceptionException, RemoteException {
        return this.resourceAdminServiceStub.addCollection(parentPath, collectionName, mediaType, description);
    }

    public void addSymbolicLink(String parentPath, String name, String targetPath) throws ResourceAdminServiceExceptionException, RemoteException {
        this.resourceAdminServiceStub.addSymbolicLink(parentPath, name, targetPath);
    }

    public void addTextResource(String parentPath, String fileName, String mediaType, String description, String content) throws RemoteException, ResourceAdminServiceExceptionException {
        this.resourceAdminServiceStub.addTextResource(parentPath, fileName, mediaType, description, content);
    }

    public void addResourcePermission(String pathToAuthorize, String roleToAuthorize, String actionToAuthorize, String permissionType) throws RemoteException, ResourceAdminServiceResourceServiceExceptionException {
        this.resourceAdminServiceStub.addRolePermission(pathToAuthorize, roleToAuthorize, actionToAuthorize, permissionType);
    }

    public String getProperty(String resourcePath, String key) throws RemoteException, ResourceAdminServiceExceptionException {
        return this.resourceAdminServiceStub.getProperty(resourcePath, key);
    }

    public MetadataBean getMetadata(String resourcePath) throws RemoteException, ResourceAdminServiceExceptionException {
        return this.resourceAdminServiceStub.getMetadata(resourcePath);
    }

    public ContentBean getResourceContent(String resourcePath) throws RemoteException, ResourceAdminServiceExceptionException {
        return this.resourceAdminServiceStub.getContentBean(resourcePath);
    }

    public ResourceData[] getResourceData(String resourcePath) throws RemoteException, ResourceAdminServiceExceptionException {
        String[] resourceArray = new String[]{resourcePath};
        return this.resourceAdminServiceStub.getResourceData(resourceArray);
    }

    public String getHumanReadableMediaTypes() throws Exception {
        try {
            return this.resourceAdminServiceStub.getHumanReadableMediaTypes();
        }
        catch (Exception e) {
            String msg = "get human readable media type error ";
            throw new Exception(msg, e);
        }
    }

    public String getMimeTypeFromHuman(String mediaType) throws Exception {
        try {
            return this.resourceAdminServiceStub.getMimeTypeFromHuman(mediaType);
        }
        catch (Exception e) {
            String msg = "get human readable media type error ";
            throw new Exception(msg, e);
        }
    }

    public void updateTextContent(String path, String content) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.updateTextContent(path, content);
        }
        catch (RemoteException e) {
            log.error((Object)("Cannot edit the content of the resource : " + e.getMessage()));
            throw new RemoteException("Edit content error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Cannot edit the content of the resource : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Get version error : ", (Throwable)e);
        }
    }

    public void copyResource(String parentPath, String oldResourcePath, String destinationPath, String targetName) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.copyResource(parentPath, oldResourcePath, destinationPath, targetName);
        }
        catch (RemoteException e) {
            log.error((Object)"Copy resource error ");
            throw new RemoteException("Copy resource error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Copy resource error");
            throw new ResourceAdminServiceExceptionException("Copy resource error", (Throwable)e);
        }
    }

    public void moveResource(String parentPath, String oldResourcePath, String destinationPath, String targetName) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.moveResource(parentPath, oldResourcePath, destinationPath, targetName);
        }
        catch (RemoteException e) {
            log.error((Object)"Move resource error ");
            throw new RemoteException("Copy resource error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Move resource error");
            throw new ResourceAdminServiceExceptionException("Copy resource error", (Throwable)e);
        }
    }

    public VersionPath[] getVersionPaths(String path) throws RemoteException, ResourceAdminServiceExceptionException {
        VersionPath[] versionPaths = null;
        try {
            VersionsBean vb = this.resourceAdminServiceStub.getVersionsBean(path);
            versionPaths = vb.getVersionPaths();
        }
        catch (RemoteException e) {
            log.error((Object)("No versions for created path : " + e.getMessage()));
            throw new RemoteException("Get version error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Get version error : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Get version error : ", (Throwable)e);
        }
        return versionPaths;
    }

    public VersionsBean getVersionsBean(String path) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            return this.resourceAdminServiceStub.getVersionsBean(path);
        }
        catch (RemoteException e) {
            log.error((Object)("Get version bean fails: " + e.getMessage()));
            throw new RemoteException("Get version bean fails:  ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Get version bean fails:  " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Get version bean fails:  : ", (Throwable)e);
        }
    }

    public void createVersion(String resourcePath) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.createVersion(resourcePath);
        }
        catch (RemoteException e) {
            log.error((Object)("Create version error : " + e.getMessage()));
            throw new RemoteException("Create version error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Create version error : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Create version error : ", (Throwable)e);
        }
    }

    public void deleteVersionHistory(String path, String snapshotID) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.deleteVersionHistory(path, snapshotID);
        }
        catch (RemoteException e) {
            log.error((Object)("No versions to delete : " + e.getMessage()));
            throw new RemoteException("Delete version error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Delete version error : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Delete version error : ", (Throwable)e);
        }
    }

    public boolean restoreVersion(String path) throws RemoteException, ResourceAdminServiceExceptionException {
        boolean status = false;
        try {
            status = this.resourceAdminServiceStub.restoreVersion(path);
        }
        catch (RemoteException e) {
            log.error((Object)("No versions to restore : " + e.getMessage()));
            throw new RemoteException("Restore version error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("Restore version error : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("Restore version error : ", (Throwable)e);
        }
        return status;
    }

    public String getTextContent(String path) throws RemoteException, ResourceAdminServiceExceptionException {
        String content = null;
        try {
            content = this.resourceAdminServiceStub.getTextContent(path);
        }
        catch (RemoteException e) {
            log.error((Object)("Unable get content : " + e.getMessage()));
            throw new RemoteException("Restore version error : ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)("GetTextContent Error : " + e.getMessage()));
            throw new ResourceAdminServiceExceptionException("GetTextContent Error :  ", (Throwable)e);
        }
        return content;
    }

    public PermissionBean getPermission(String path) throws Exception {
        try {
            return this.resourceAdminServiceStub.getPermissions(path);
        }
        catch (Exception e) {
            log.error((Object)("Unable to get permission : " + e.getMessage()));
            throw new Exception("Unable to get permission : ", e);
        }
    }

    public void renameResource(String parentPath, String oldResourcePath, String newResourceName) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            this.resourceAdminServiceStub.renameResource(parentPath, oldResourcePath, newResourceName);
        }
        catch (RemoteException e) {
            log.error((Object)"Rename resource error ");
            throw new RemoteException("Rename resource error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Rename resource error");
            throw new ResourceAdminServiceExceptionException("Rename resource error", (Throwable)e);
        }
    }

    public boolean addExtension(String name, DataHandler content) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            return this.resourceAdminServiceStub.addExtension(name, content);
        }
        catch (RemoteException e) {
            log.error((Object)"Add extension error ");
            throw new RemoteException("Rename resource error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Add Extension error");
            throw new ResourceAdminServiceExceptionException("Rename resource error", (Throwable)e);
        }
    }

    public boolean removeExtension(String name) throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            return this.resourceAdminServiceStub.removeExtension(name);
        }
        catch (RemoteException e) {
            log.error((Object)"Remove extension error ");
            throw new RemoteException("Remove resource error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Remove Extension error");
            throw new ResourceAdminServiceExceptionException("Remove resource error", (Throwable)e);
        }
    }

    public String[] listExtensions() throws RemoteException, ResourceAdminServiceExceptionException {
        try {
            return this.resourceAdminServiceStub.listExtensions();
        }
        catch (RemoteException e) {
            log.error((Object)"List extensions error ");
            throw new RemoteException("List extensions error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"List extensions error ");
            throw new ResourceAdminServiceExceptionException("List extensions error ", (Throwable)e);
        }
    }

    public void setDescription(String path, String description) throws RemoteException, RegistryExceptionException {
        try {
            this.resourceAdminServiceStub.setDescription(path, description);
        }
        catch (RemoteException e) {
            String msg = "Unable set description for the path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RemoteException("List extensions error ", e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            String msg = "Unable set description for the path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public ContentDownloadBean getContentDownloadBean(String path) throws RemoteException, RegistryExceptionException {
        try {
            return this.resourceAdminServiceStub.getContentDownloadBean(path);
        }
        catch (RemoteException e) {
            String msg = "Unable to retrieve content download bean - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RemoteException(msg, e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            String msg = "Unable to retrieve content download bean - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public ResourceTreeEntryBean getResourceTreeEntryBean(String resourcePath) throws RemoteException, RegistryExceptionException {
        try {
            return this.resourceAdminServiceStub.getResourceTreeEntry(resourcePath);
        }
        catch (RemoteException e) {
            String msg = "Unable get resource tree entry";
            log.error((Object)msg, (Throwable)e);
            throw new RemoteException(msg, e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            String msg = "Unable get resource tree entry";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }
}

