/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.idp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.identity.application.common.model.idp.xsd.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.idp.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.idp.xsd.ProvisioningConnectorConfig;
import org.wso2.carbon.idp.mgt.stub.IdentityProviderMgtServiceStub;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserStoreInfo;

public class IdentityProviderMgtServiceClient {
    private static Log log = LogFactory.getLog(IdentityProviderMgtServiceClient.class);
    private IdentityProviderMgtServiceStub idPMgtStub;
    private UserAdminStub userAdminStub;

    public IdentityProviderMgtServiceClient(String userName, String password, String backEndUrl) throws AxisFault {
        String idPMgtServiceURL = backEndUrl + "IdentityProviderMgtService";
        String userAdminServiceURL = backEndUrl + "UserAdmin";
        this.idPMgtStub = new IdentityProviderMgtServiceStub(idPMgtServiceURL);
        this.userAdminStub = new UserAdminStub(userAdminServiceURL);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.idPMgtStub);
    }

    public IdentityProviderMgtServiceClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String idPMgtServiceURL = backEndUrl + "IdentityProviderMgtService";
        String userAdminServiceURL = backEndUrl + "UserAdmin";
        this.idPMgtStub = new IdentityProviderMgtServiceStub(idPMgtServiceURL);
        this.userAdminStub = new UserAdminStub(userAdminServiceURL);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.idPMgtStub);
    }

    public IdentityProviderMgtServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) {
        String idPMgtServiceURL = backendServerURL + "IdentityProviderMgtService";
        String userAdminServiceURL = backendServerURL + "UserAdmin";
        try {
            this.idPMgtStub = new IdentityProviderMgtServiceStub(configCtx, idPMgtServiceURL);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while instantiating IdentityProviderMgtServiceStub", (Throwable)axisFault);
        }
        try {
            this.userAdminStub = new UserAdminStub(configCtx, userAdminServiceURL);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while instantiating UserAdminServiceStub", (Throwable)axisFault);
        }
        ServiceClient idPMgtClient = this.idPMgtStub._getServiceClient();
        ServiceClient userAdminClient = this.userAdminStub._getServiceClient();
        Options idPMgtOptions = idPMgtClient.getOptions();
        idPMgtOptions.setManageSession(true);
        idPMgtOptions.setProperty("Cookie", (Object)cookie);
        Options userAdminOptions = userAdminClient.getOptions();
        userAdminOptions.setManageSession(true);
        userAdminOptions.setProperty("Cookie", (Object)cookie);
    }

    public IdentityProvider getResidentIdP() throws Exception {
        try {
            return this.idPMgtStub.getResidentIdP();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Identity Providers");
        }
    }

    public void updateResidentIdP(IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.updateResidentIdP(identityProvider);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while updating resident identity provider");
        }
    }

    public List<IdentityProvider> getIdPs() throws Exception {
        try {
            IdentityProvider[] identityProviders = this.idPMgtStub.getAllIdPs();
            if (identityProviders != null && identityProviders.length > 0) {
                return Arrays.asList(identityProviders);
            }
            return new ArrayList<IdentityProvider>();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Identity Providers");
        }
    }

    public List<IdentityProvider> getPaginatedIdPsInfo(String filter, int pageNumber) throws Exception {
        IdentityProvider[] identityProviders = this.idPMgtStub.getPaginatedIdpInfo(filter, pageNumber);
        if (identityProviders != null && identityProviders.length > 0) {
            return Arrays.asList(identityProviders);
        }
        return new ArrayList<IdentityProvider>();
    }

    public List<IdentityProvider> getAllPaginatedIdPsInfo(int pageNumber) throws Exception {
        IdentityProvider[] identityProviders = this.idPMgtStub.getAllPaginatedIdpInfo(pageNumber);
        if (identityProviders != null && identityProviders.length > 0) {
            return Arrays.asList(identityProviders);
        }
        return new ArrayList<IdentityProvider>();
    }

    public int getFilteredIdpCount(String filter) throws Exception {
        return this.idPMgtStub.getFilteredIdpCount(filter);
    }

    public int getAllIdpCount() throws Exception {
        return this.idPMgtStub.getAllIdpCount();
    }

    public List<IdentityProvider> getEnabledIdPs() throws Exception {
        try {
            IdentityProvider[] identityProviders = this.idPMgtStub.getEnabledAllIdPs();
            if (identityProviders != null && identityProviders.length > 0) {
                return Arrays.asList(identityProviders);
            }
            return new ArrayList<IdentityProvider>();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving list of Enabled Identity Providers");
        }
    }

    public IdentityProvider getIdPByName(String idPName) throws Exception {
        try {
            return this.idPMgtStub.getIdPByName(idPName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving information about " + idPName);
        }
    }

    public void addIdP(IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.addIdP(identityProvider);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while adding Identity Provider " + identityProvider.getIdentityProviderName());
        }
    }

    public void deleteIdP(String idPName) throws Exception {
        this.idPMgtStub.deleteIdP(idPName);
    }

    public IdentityProviderMgtServiceStub getIdPMgtStub() {
        return this.idPMgtStub;
    }

    public void updateIdP(String oldIdPName, IdentityProvider identityProvider) throws Exception {
        try {
            this.idPMgtStub.updateIdP(oldIdPName, identityProvider);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while deleting Identity Provider " + oldIdPName);
        }
    }

    public Map<String, FederatedAuthenticatorConfig> getAllFederatedAuthenticators() throws Exception {
        HashMap<String, FederatedAuthenticatorConfig> configMap = new HashMap<String, FederatedAuthenticatorConfig>();
        try {
            FederatedAuthenticatorConfig[] fedAuthConfigs = this.idPMgtStub.getAllFederatedAuthenticators();
            if (fedAuthConfigs != null && fedAuthConfigs.length > 0) {
                for (FederatedAuthenticatorConfig config : fedAuthConfigs) {
                    if (config.getDisplayName().equals("facebook") || config.getDisplayName().equals("openid") || config.getDisplayName().equals("openidconnect") || config.getDisplayName().equals("samlsso") || config.getDisplayName().equals("passovests")) continue;
                    configMap.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving all local claim URIs");
        }
        return configMap;
    }

    public Map<String, FederatedAuthenticatorConfig> getAllAvailableFederatedAuthenticators() throws Exception {
        HashMap<String, FederatedAuthenticatorConfig> configMap = new HashMap<String, FederatedAuthenticatorConfig>();
        try {
            FederatedAuthenticatorConfig[] fedAuthConfigs = this.idPMgtStub.getAllFederatedAuthenticators();
            if (fedAuthConfigs != null && fedAuthConfigs.length > 0) {
                for (FederatedAuthenticatorConfig config : fedAuthConfigs) {
                    configMap.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving all local claim URIs");
        }
        return configMap;
    }

    public Map<String, ProvisioningConnectorConfig> getCustomProvisioningConnectors() throws Exception {
        HashMap<String, ProvisioningConnectorConfig> provisioningConnectors = new HashMap<String, ProvisioningConnectorConfig>();
        try {
            ProvisioningConnectorConfig[] provisioningConnectorConfigs = this.idPMgtStub.getAllProvisioningConnectors();
            if (provisioningConnectorConfigs != null && provisioningConnectorConfigs.length > 0 && provisioningConnectorConfigs[0] != null) {
                for (ProvisioningConnectorConfig config : provisioningConnectorConfigs) {
                    if (config.getName().equals("scim") || config.getName().equals("salesforce") || config.getName().equals("googleapps")) continue;
                    provisioningConnectors.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving all Provisioning Connectors");
        }
        return provisioningConnectors;
    }

    public Map<String, ProvisioningConnectorConfig> getAllProvisioningConnectors() throws Exception {
        HashMap<String, ProvisioningConnectorConfig> provisioningConnectors = new HashMap<String, ProvisioningConnectorConfig>();
        try {
            ProvisioningConnectorConfig[] provisioningConnectorConfigs = this.idPMgtStub.getAllProvisioningConnectors();
            if (provisioningConnectorConfigs != null && provisioningConnectorConfigs.length > 0 && provisioningConnectorConfigs[0] != null) {
                for (ProvisioningConnectorConfig config : provisioningConnectorConfigs) {
                    provisioningConnectors.put(config.getName(), config);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving all Provisioning Connectors");
        }
        return provisioningConnectors;
    }

    public String[] getAllLocalClaimUris() throws Exception {
        try {
            return this.idPMgtStub.getAllLocalClaimUris();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving all local claim URIs");
        }
    }

    public String[] getUserStoreDomains() throws Exception {
        try {
            UserStoreInfo[] storesInfo;
            ArrayList<String> readWriteDomainNames = new ArrayList<String>();
            for (UserStoreInfo storeInfo : storesInfo = this.userAdminStub.getUserRealmInfo().getUserStoresInfo()) {
                if (storeInfo.getReadOnly()) continue;
                readWriteDomainNames.add(storeInfo.getDomainName());
            }
            return readWriteDomainNames.toArray(new String[readWriteDomainNames.size()]);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Error occurred while retrieving Read-Write User Store Domain IDs for logged-in user's tenant realm");
        }
    }
}

