/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.sequences;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.sequences.stub.types.SequenceAdminServiceStub;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.carbon.sequences.stub.types.common.to.SequenceInfo;

public class SequenceAdminServiceClient {
    private static final Log log = LogFactory.getLog(SequenceAdminServiceClient.class);
    private final String serviceName = "SequenceAdminService";
    private SequenceAdminServiceStub sequenceAdminServiceStub;

    public SequenceAdminServiceClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "SequenceAdminService";
        this.sequenceAdminServiceStub = new SequenceAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.sequenceAdminServiceStub);
    }

    public SequenceAdminServiceClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "SequenceAdminService";
        this.sequenceAdminServiceStub = new SequenceAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.sequenceAdminServiceStub);
    }

    public void addSequence(DataHandler dh) throws SequenceEditorException, IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement sequenceElem = builder.getDocumentElement();
        this.sequenceAdminServiceStub.addSequence(sequenceElem);
    }

    public void addSequence(OMElement sequence) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.addSequence(sequence);
    }

    public void updateSequence(OMElement sequence) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.saveSequence(sequence);
    }

    public void addDynamicSequence(String key, OMElement omElement) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.addDynamicSequence(key, omElement);
    }

    public OMElement getSequence(String sequenceName) throws SequenceEditorException, RemoteException {
        return this.sequenceAdminServiceStub.getSequence(sequenceName);
    }

    public void deleteSequence(String sequenceName) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.deleteSequence(sequenceName);
    }

    public void updateDynamicSequence(String key, OMElement OmSequence) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.updateDynamicSequence(key, OmSequence);
    }

    public int getDynamicSequenceCount() throws SequenceEditorException, RemoteException {
        return this.sequenceAdminServiceStub.getDynamicSequenceCount();
    }

    public void deleteDynamicSequence(String key) throws SequenceEditorException, RemoteException {
        this.sequenceAdminServiceStub.deleteDynamicSequence(key);
    }

    public SequenceInfo[] getSequences(int pageNo, int sequencePerPage) throws SequenceEditorException, RemoteException {
        return this.sequenceAdminServiceStub.getSequences(pageNo, sequencePerPage);
    }

    public String[] getSequences() throws SequenceEditorException, RemoteException {
        SequenceInfo[] info = this.sequenceAdminServiceStub.getSequences(0, 200);
        if (info == null || info.length <= 0) {
            return null;
        }
        String[] sequences = new String[info.length];
        for (int i = 0; i < info.length; ++i) {
            sequences[i] = info[i].getName();
        }
        return sequences;
    }

    public String[] getDynamicSequences() throws SequenceEditorException, RemoteException {
        SequenceInfo[] seqInfo = this.sequenceAdminServiceStub.getDynamicSequences(0, 200);
        if (seqInfo == null || seqInfo.length <= 0) {
            return null;
        }
        String[] sequences = new String[seqInfo.length];
        for (int i = 0; i < seqInfo.length; ++i) {
            sequences[i] = seqInfo[i].getName();
        }
        return sequences;
    }
}

