/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.tasks;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.task.stub.TaskAdminStub;
import org.wso2.carbon.task.stub.TaskManagementException;

public class TaskAdminClient {
    private static final Log log = LogFactory.getLog(TaskAdminClient.class);
    private final String serviceName = "TaskAdmin";
    private TaskAdminStub taskAdminStub;

    public TaskAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "TaskAdmin";
        this.taskAdminStub = new TaskAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.taskAdminStub);
    }

    public TaskAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "TaskAdmin";
        this.taskAdminStub = new TaskAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.taskAdminStub);
    }

    public void addTask(DataHandler dh) throws TaskManagementException, IOException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement scheduleTaskElem = builder.getDocumentElement();
        this.taskAdminStub.addTaskDescription(scheduleTaskElem);
    }

    public void addTask(OMElement scheduleTaskElem) throws TaskManagementException, RemoteException {
        this.taskAdminStub.addTaskDescription(scheduleTaskElem);
    }

    public void deleteTask(String name, String group) throws TaskManagementException, RemoteException {
        this.taskAdminStub.deleteTaskDescription(name, group);
    }

    public OMElement getScheduleTask(String name, String group) throws TaskManagementException, RemoteException {
        return this.taskAdminStub.getTaskDescription(name, group);
    }

    public OMElement getAllTaskDescriptions() throws RemoteException, TaskManagementException {
        return this.taskAdminStub.getAllTaskDescriptions(null);
    }

    public List<String> getScheduleTaskList() throws RemoteException, TaskManagementException {
        ArrayList<String> taskList = new ArrayList<String>();
        OMElement tasksOme = this.getAllTaskDescriptions().getFirstElement();
        if (tasksOme != null) {
            Iterator itr = tasksOme.getChildrenWithName(new QName("task"));
            while (itr.hasNext()) {
                OMElement taskOme = (OMElement)itr.next();
                taskList.add(taskOme.getAttributeValue(new QName("name")));
            }
        }
        return taskList;
    }
}

