/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.admin.clients.localentry;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.admin.clients.client.utils.AuthenticateStub;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminException;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminServiceStub;

public class LocalEntriesAdminClient {
    private static final Log log = LogFactory.getLog(LocalEntriesAdminClient.class);
    private LocalEntryAdminServiceStub localEntryAdminServiceStub;
    private final String serviceName = "LocalEntryAdmin";

    public LocalEntriesAdminClient(String backendUrl, String sessionCookie) throws AxisFault {
        String endPoint = backendUrl + "LocalEntryAdmin";
        this.localEntryAdminServiceStub = new LocalEntryAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.localEntryAdminServiceStub);
    }

    public LocalEntriesAdminClient(String backendUrl, String userName, String password) throws AxisFault {
        String endPoint = backendUrl + "LocalEntryAdmin";
        this.localEntryAdminServiceStub = new LocalEntryAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.localEntryAdminServiceStub);
    }

    public boolean addLocalEntery(DataHandler dh) throws IOException, LocalEntryAdminException, XMLStreamException {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement localEntryElem = builder.getDocumentElement();
        return this.localEntryAdminServiceStub.addEntry(localEntryElem.toString());
    }

    public boolean addLocalEntry(OMElement localEntry) throws LocalEntryAdminException, RemoteException {
        return this.localEntryAdminServiceStub.addEntry(localEntry.toString());
    }

    public boolean deleteLocalEntry(String localEntryKey) throws LocalEntryAdminException, RemoteException {
        return this.localEntryAdminServiceStub.deleteEntry(localEntryKey);
    }

    public String getEntryNamesString() throws LocalEntryAdminException, RemoteException {
        return this.localEntryAdminServiceStub.getEntryNamesString();
    }

    public int getEntryDataCount() throws LocalEntryAdminException, RemoteException {
        return this.localEntryAdminServiceStub.getEntryDataCount();
    }

    public String[] getEntryNames() throws LocalEntryAdminException, RemoteException {
        return this.localEntryAdminServiceStub.getEntryNames();
    }
}

