/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.services.jaxrs.peoplesample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Service;
import org.wso2.am.integration.services.jaxrs.peoplesample.bean.Person;
import org.wso2.am.integration.services.jaxrs.peoplesample.exceptions.PersonAlreadyExistsException;
import org.wso2.am.integration.services.jaxrs.peoplesample.exceptions.PersonNotFoundException;

@Service
public class PeopleService {
    private ConcurrentMap<String, Person> persons = new ConcurrentHashMap<String, Person>();

    public void setInitPeople() {
        for (int count = 1; count <= 10; ++count) {
            Person newPerson = new Person();
            newPerson.setEmail(String.format("test-%d@wso2.com", count));
            newPerson.setFirstName(String.format("testUser%d", count));
            newPerson.setLastName(String.format("testLasrName%d", count));
            this.persons.putIfAbsent(String.format("test-%d@wso2.com", count), newPerson);
        }
    }

    public Collection<Person> getPeople(int page, int pageSize) {
        ArrayList<Person> person = new ArrayList<Person>(pageSize);
        for (int index = 0; index < pageSize; ++index) {
            person.add(new Person(String.format("person+%d@at.com", pageSize * (page - 1) + index + 1)));
        }
        this.setInitPeople();
        return person;
    }

    public Person addPerson(String email) {
        return new Person(email);
    }

    public Person getByEmail(String email) {
        Person person = (Person)this.persons.get(email);
        if (person == null) {
            throw new PersonNotFoundException(email);
        }
        return person;
    }

    public boolean checkPersonByEmail(String email) {
        boolean personExists = true;
        Person person = (Person)this.persons.get(email);
        if (person == null) {
            personExists = false;
        }
        return personExists;
    }

    public Person addPerson(String email, String firstName, String lastName) {
        Person person = new Person(email);
        person.setFirstName(firstName);
        person.setLastName(lastName);
        if (this.persons.putIfAbsent(email, person) != null) {
            throw new PersonAlreadyExistsException(email);
        }
        return person;
    }

    public void removePerson(String email) {
        if (this.persons.remove(email) == null) {
            throw new PersonNotFoundException(email);
        }
    }
}

