/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.services.jaxrs.coffeesample.bean;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Order")
public class Order {
    private String orderId = UUID.randomUUID().toString();
    private String drinkName;
    private String additions;
    private double cost;
    private boolean locked;
    private long timestamp = System.currentTimeMillis();
    public static final NumberFormat currencyFormat = new DecimalFormat("#.##");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'");

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getDrinkName() {
        return this.drinkName;
    }

    public void setDrinkName(String drinkName) {
        this.drinkName = drinkName;
        this.timestamp = System.currentTimeMillis();
    }

    public String getAdditions() {
        return this.additions;
    }

    public void setAdditions(String additions) {
        this.additions = additions;
        this.timestamp = System.currentTimeMillis();
    }

    public String getCost() {
        return currencyFormat.format(this.cost);
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getTimestamp() {
        return dateFormat.format(new Date(this.timestamp));
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isAmountAcceptable(double amount) {
        return amount >= this.cost;
    }
}

