/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;

public class ApiProductIndividualApi {
    private ApiClient apiClient;

    public ApiProductIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call exportApiProductGetCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/export/api-product";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("version", version));
        }
        if (providerName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("providerName", providerName));
        }
        if (format != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        }
        if (preserveStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserveStatus", preserveStatus));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/zip"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportApiProductGetValidateBeforeCall(String name, String version, String providerName, String format, Boolean preserveStatus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling exportApiProductGet(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling exportApiProductGet(Async)");
        }
        Call call = this.exportApiProductGetCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        return call;
    }

    public File exportApiProductGet(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        ApiResponse<File> resp = this.exportApiProductGetWithHttpInfo(name, version, providerName, format, preserveStatus);
        return resp.getData();
    }

    public ApiResponse<File> exportApiProductGetWithHttpInfo(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        Call call = this.exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportApiProductGetAsync(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importApiProductPostCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/import/api-product";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveProvider != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("preserveProvider", preserveProvider));
        }
        if (importAPIs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("importAPIs", importAPIs));
        }
        if (overwriteAPIProduct != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("overwriteAPIProduct", overwriteAPIProduct));
        }
        if (overwriteAPIs != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("overwriteAPIs", overwriteAPIs));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importApiProductPostValidateBeforeCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApiProductPost(Async)");
        }
        Call call = this.importApiProductPostCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, progressListener, progressRequestListener);
        return call;
    }

    public void importApiProductPost(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        this.importApiProductPostWithHttpInfo(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs);
    }

    public ApiResponse<Void> importApiProductPostWithHttpInfo(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        Call call = this.importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, null, null);
        return this.apiClient.execute(call);
    }

    public Call importApiProductPostAsync(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

