/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;
import org.wso2.am.integration.clients.admin.api.dto.CustomRuleDTO;

public class CustomRulesIndividualApi {
    private ApiClient apiClient;

    public CustomRulesIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomRulesIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call throttlingPoliciesCustomRuleIdDeleteCall(String ruleId, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling/policies/custom/{ruleId}".replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesCustomRuleIdDeleteValidateBeforeCall(String ruleId, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling throttlingPoliciesCustomRuleIdDelete(Async)");
        }
        Call call = this.throttlingPoliciesCustomRuleIdDeleteCall(ruleId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void throttlingPoliciesCustomRuleIdDelete(String ruleId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.throttlingPoliciesCustomRuleIdDeleteWithHttpInfo(ruleId, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> throttlingPoliciesCustomRuleIdDeleteWithHttpInfo(String ruleId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesCustomRuleIdDeleteValidateBeforeCall(ruleId, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call throttlingPoliciesCustomRuleIdDeleteAsync(String ruleId, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesCustomRuleIdDeleteValidateBeforeCall(ruleId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call throttlingPoliciesCustomRuleIdGetCall(String ruleId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/throttling/policies/custom/{ruleId}".replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesCustomRuleIdGetValidateBeforeCall(String ruleId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling throttlingPoliciesCustomRuleIdGet(Async)");
        }
        Call call = this.throttlingPoliciesCustomRuleIdGetCall(ruleId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public CustomRuleDTO throttlingPoliciesCustomRuleIdGet(String ruleId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<CustomRuleDTO> resp = this.throttlingPoliciesCustomRuleIdGetWithHttpInfo(ruleId, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<CustomRuleDTO> throttlingPoliciesCustomRuleIdGetWithHttpInfo(String ruleId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesCustomRuleIdGetValidateBeforeCall(ruleId, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<CustomRuleDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesCustomRuleIdGetAsync(String ruleId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<CustomRuleDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesCustomRuleIdGetValidateBeforeCall(ruleId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRuleDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call throttlingPoliciesCustomRuleIdPutCall(String ruleId, CustomRuleDTO body, String contentType, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomRuleDTO localVarPostBody = body;
        String localVarPath = "/throttling/policies/custom/{ruleId}".replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call throttlingPoliciesCustomRuleIdPutValidateBeforeCall(String ruleId, CustomRuleDTO body, String contentType, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling throttlingPoliciesCustomRuleIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling throttlingPoliciesCustomRuleIdPut(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling throttlingPoliciesCustomRuleIdPut(Async)");
        }
        Call call = this.throttlingPoliciesCustomRuleIdPutCall(ruleId, body, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public CustomRuleDTO throttlingPoliciesCustomRuleIdPut(String ruleId, CustomRuleDTO body, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<CustomRuleDTO> resp = this.throttlingPoliciesCustomRuleIdPutWithHttpInfo(ruleId, body, contentType, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<CustomRuleDTO> throttlingPoliciesCustomRuleIdPutWithHttpInfo(String ruleId, CustomRuleDTO body, String contentType, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.throttlingPoliciesCustomRuleIdPutValidateBeforeCall(ruleId, body, contentType, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<CustomRuleDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call throttlingPoliciesCustomRuleIdPutAsync(String ruleId, CustomRuleDTO body, String contentType, String ifMatch, String ifUnmodifiedSince, final ApiCallback<CustomRuleDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.throttlingPoliciesCustomRuleIdPutValidateBeforeCall(ruleId, body, contentType, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRuleDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

