/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerDTO;

public class KeyManagerIndividualApi {
    private ApiClient apiClient;

    public KeyManagerIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagerIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call keyManagersKeyManagerIdDeleteCall(String keyManagerId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/key-managers/{keyManagerId}".replaceAll("\\{keyManagerId\\}", this.apiClient.escapeString(keyManagerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call keyManagersKeyManagerIdDeleteValidateBeforeCall(String keyManagerId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyManagerId == null) {
            throw new ApiException("Missing the required parameter 'keyManagerId' when calling keyManagersKeyManagerIdDelete(Async)");
        }
        Call call = this.keyManagersKeyManagerIdDeleteCall(keyManagerId, progressListener, progressRequestListener);
        return call;
    }

    public void keyManagersKeyManagerIdDelete(String keyManagerId) throws ApiException {
        this.keyManagersKeyManagerIdDeleteWithHttpInfo(keyManagerId);
    }

    public ApiResponse<Void> keyManagersKeyManagerIdDeleteWithHttpInfo(String keyManagerId) throws ApiException {
        Call call = this.keyManagersKeyManagerIdDeleteValidateBeforeCall(keyManagerId, null, null);
        return this.apiClient.execute(call);
    }

    public Call keyManagersKeyManagerIdDeleteAsync(String keyManagerId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.keyManagersKeyManagerIdDeleteValidateBeforeCall(keyManagerId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call keyManagersKeyManagerIdGetCall(String keyManagerId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/key-managers/{keyManagerId}".replaceAll("\\{keyManagerId\\}", this.apiClient.escapeString(keyManagerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call keyManagersKeyManagerIdGetValidateBeforeCall(String keyManagerId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyManagerId == null) {
            throw new ApiException("Missing the required parameter 'keyManagerId' when calling keyManagersKeyManagerIdGet(Async)");
        }
        Call call = this.keyManagersKeyManagerIdGetCall(keyManagerId, progressListener, progressRequestListener);
        return call;
    }

    public KeyManagerDTO keyManagersKeyManagerIdGet(String keyManagerId) throws ApiException {
        ApiResponse<KeyManagerDTO> resp = this.keyManagersKeyManagerIdGetWithHttpInfo(keyManagerId);
        return resp.getData();
    }

    public ApiResponse<KeyManagerDTO> keyManagersKeyManagerIdGetWithHttpInfo(String keyManagerId) throws ApiException {
        Call call = this.keyManagersKeyManagerIdGetValidateBeforeCall(keyManagerId, null, null);
        Type localVarReturnType = new TypeToken<KeyManagerDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call keyManagersKeyManagerIdGetAsync(String keyManagerId, final ApiCallback<KeyManagerDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.keyManagersKeyManagerIdGetValidateBeforeCall(keyManagerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KeyManagerDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call keyManagersKeyManagerIdPutCall(String keyManagerId, KeyManagerDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        KeyManagerDTO localVarPostBody = body;
        String localVarPath = "/key-managers/{keyManagerId}".replaceAll("\\{keyManagerId\\}", this.apiClient.escapeString(keyManagerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call keyManagersKeyManagerIdPutValidateBeforeCall(String keyManagerId, KeyManagerDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (keyManagerId == null) {
            throw new ApiException("Missing the required parameter 'keyManagerId' when calling keyManagersKeyManagerIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling keyManagersKeyManagerIdPut(Async)");
        }
        Call call = this.keyManagersKeyManagerIdPutCall(keyManagerId, body, progressListener, progressRequestListener);
        return call;
    }

    public KeyManagerDTO keyManagersKeyManagerIdPut(String keyManagerId, KeyManagerDTO body) throws ApiException {
        ApiResponse<KeyManagerDTO> resp = this.keyManagersKeyManagerIdPutWithHttpInfo(keyManagerId, body);
        return resp.getData();
    }

    public ApiResponse<KeyManagerDTO> keyManagersKeyManagerIdPutWithHttpInfo(String keyManagerId, KeyManagerDTO body) throws ApiException {
        Call call = this.keyManagersKeyManagerIdPutValidateBeforeCall(keyManagerId, body, null, null);
        Type localVarReturnType = new TypeToken<KeyManagerDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call keyManagersKeyManagerIdPutAsync(String keyManagerId, KeyManagerDTO body, final ApiCallback<KeyManagerDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.keyManagersKeyManagerIdPutValidateBeforeCall(keyManagerId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KeyManagerDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

