/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowInfoDTO;

public class WorkflowsIndividualApi {
    private ApiClient apiClient;

    public WorkflowsIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call workflowsExternalWorkflowRefGetCall(String externalWorkflowRef, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/workflows/{externalWorkflowRef}".replaceAll("\\{externalWorkflowRef\\}", this.apiClient.escapeString(externalWorkflowRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workflowsExternalWorkflowRefGetValidateBeforeCall(String externalWorkflowRef, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (externalWorkflowRef == null) {
            throw new ApiException("Missing the required parameter 'externalWorkflowRef' when calling workflowsExternalWorkflowRefGet(Async)");
        }
        Call call = this.workflowsExternalWorkflowRefGetCall(externalWorkflowRef, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowInfoDTO workflowsExternalWorkflowRefGet(String externalWorkflowRef, String ifNoneMatch) throws ApiException {
        ApiResponse<WorkflowInfoDTO> resp = this.workflowsExternalWorkflowRefGetWithHttpInfo(externalWorkflowRef, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<WorkflowInfoDTO> workflowsExternalWorkflowRefGetWithHttpInfo(String externalWorkflowRef, String ifNoneMatch) throws ApiException {
        Call call = this.workflowsExternalWorkflowRefGetValidateBeforeCall(externalWorkflowRef, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<WorkflowInfoDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workflowsExternalWorkflowRefGetAsync(String externalWorkflowRef, String ifNoneMatch, final ApiCallback<WorkflowInfoDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workflowsExternalWorkflowRefGetValidateBeforeCall(externalWorkflowRef, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowInfoDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call workflowsUpdateWorkflowStatusPostCall(String workflowReferenceId, WorkflowDTO body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        WorkflowDTO localVarPostBody = body;
        String localVarPath = "/workflows/update-workflow-status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (workflowReferenceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("workflowReferenceId", workflowReferenceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call workflowsUpdateWorkflowStatusPostValidateBeforeCall(String workflowReferenceId, WorkflowDTO body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (workflowReferenceId == null) {
            throw new ApiException("Missing the required parameter 'workflowReferenceId' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowsUpdateWorkflowStatusPost(Async)");
        }
        Call call = this.workflowsUpdateWorkflowStatusPostCall(workflowReferenceId, body, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowDTO workflowsUpdateWorkflowStatusPost(String workflowReferenceId, WorkflowDTO body) throws ApiException {
        ApiResponse<WorkflowDTO> resp = this.workflowsUpdateWorkflowStatusPostWithHttpInfo(workflowReferenceId, body);
        return resp.getData();
    }

    public ApiResponse<WorkflowDTO> workflowsUpdateWorkflowStatusPostWithHttpInfo(String workflowReferenceId, WorkflowDTO body) throws ApiException {
        Call call = this.workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, null, null);
        Type localVarReturnType = new TypeToken<WorkflowDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call workflowsUpdateWorkflowStatusPostAsync(String workflowReferenceId, WorkflowDTO body, final ApiCallback<WorkflowDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.workflowsUpdateWorkflowStatusPostValidateBeforeCall(workflowReferenceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

