/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.clients.admin.api.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class WorkflowInfoDTO {
    @SerializedName(value="workflowType")
    private WorkflowTypeEnum workflowType = null;
    @SerializedName(value="workflowStatus")
    private WorkflowStatusEnum workflowStatus = null;
    @SerializedName(value="createdTime")
    private String createdTime = null;
    @SerializedName(value="updatedTime")
    private String updatedTime = null;
    @SerializedName(value="referenceId")
    private String referenceId = null;
    @SerializedName(value="properties")
    private Object properties = null;
    @SerializedName(value="description")
    private String description = null;

    public WorkflowInfoDTO workflowType(WorkflowTypeEnum workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    @ApiModelProperty(example="APPLICATION_CREATION", value="Type of the Workflow Request. It shows which type of request is it. ")
    public WorkflowTypeEnum getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowTypeEnum workflowType) {
        this.workflowType = workflowType;
    }

    public WorkflowInfoDTO workflowStatus(WorkflowStatusEnum workflowStatus) {
        this.workflowStatus = workflowStatus;
        return this;
    }

    @ApiModelProperty(example="APPROVED", value="Show the Status of the the workflow request whether it is approved or created. ")
    public WorkflowStatusEnum getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(WorkflowStatusEnum workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public WorkflowInfoDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(example="2020-02-10 10:10:19.704", value="Time of the the workflow request created. ")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public WorkflowInfoDTO updatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
        return this;
    }

    @ApiModelProperty(example="2020-02-10 10:10:19.704", value="Time of the the workflow request updated. ")
    public String getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    public WorkflowInfoDTO referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(example="5871244b-d6f3-466e-8995-8accd1e64303", value="Workflow external reference is used to identify the workflow requests uniquely. ")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public WorkflowInfoDTO properties(Object properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(value="")
    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public WorkflowInfoDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Approve application [APP1] creation request from application creator - admin with throttling tier - 10MinPer", value="description is a message with basic details about the workflow request. ")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowInfoDTO workflowInfo = (WorkflowInfoDTO)o;
        return Objects.equals((Object)this.workflowType, (Object)workflowInfo.workflowType) && Objects.equals((Object)this.workflowStatus, (Object)workflowInfo.workflowStatus) && Objects.equals(this.createdTime, workflowInfo.createdTime) && Objects.equals(this.updatedTime, workflowInfo.updatedTime) && Objects.equals(this.referenceId, workflowInfo.referenceId) && Objects.equals(this.properties, workflowInfo.properties) && Objects.equals(this.description, workflowInfo.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workflowType, this.workflowStatus, this.createdTime, this.updatedTime, this.referenceId, this.properties, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowInfoDTO {\n");
        sb.append("    workflowType: ").append(this.toIndentedString((Object)this.workflowType)).append("\n");
        sb.append("    workflowStatus: ").append(this.toIndentedString((Object)this.workflowStatus)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WorkflowStatusEnum {
        APPROVED("APPROVED"),
        CREATED("CREATED");

        private String value;

        private WorkflowStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WorkflowStatusEnum fromValue(String text) {
            for (WorkflowStatusEnum b : WorkflowStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WorkflowStatusEnum> {
            public void write(JsonWriter jsonWriter, WorkflowStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WorkflowStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WorkflowStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WorkflowTypeEnum {
        APPLICATION_CREATION("APPLICATION_CREATION"),
        SUBSCRIPTION_CREATION("SUBSCRIPTION_CREATION"),
        USER_SIGNUP("USER_SIGNUP"),
        APPLICATION_REGISTRATION_PRODUCTION("APPLICATION_REGISTRATION_PRODUCTION"),
        APPLICATION_REGISTRATION_SANDBOX("APPLICATION_REGISTRATION_SANDBOX"),
        APPLICATION_DELETION("APPLICATION_DELETION"),
        API_STATE("API_STATE"),
        SUBSCRIPTION_DELETION("SUBSCRIPTION_DELETION");

        private String value;

        private WorkflowTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WorkflowTypeEnum fromValue(String text) {
            for (WorkflowTypeEnum b : WorkflowTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<WorkflowTypeEnum> {
            public void write(JsonWriter jsonWriter, WorkflowTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WorkflowTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WorkflowTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

