/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api;

import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.admin.api.dto.ErrorDTO;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiIndividualApi {
    private ApiClient apiClient;

    public ApiIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for exportApiGet
     * @param name API Name  (required)
     * @param version Version of the API  (required)
     * @param providerName Provider name of the API  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Status on export  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call exportApiGetCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/export/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (version != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
        if (providerName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("providerName", providerName));
        if (format != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("format", format));
        if (preserveStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("preserveStatus", preserveStatus));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/zip"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call exportApiGetValidateBeforeCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling exportApiGet(Async)");
        }
        
        // verify the required parameter 'version' is set
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling exportApiGet(Async)");
        }
        

        com.squareup.okhttp.Call call = exportApiGetCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export an API
     * This operation can be used to export the details of a particular API as a zip file. 
     * @param name API Name  (required)
     * @param version Version of the API  (required)
     * @param providerName Provider name of the API  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Status on export  (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File exportApiGet(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        ApiResponse<File> resp = exportApiGetWithHttpInfo(name, version, providerName, format, preserveStatus);
        return resp.getData();
    }

    /**
     * Export an API
     * This operation can be used to export the details of a particular API as a zip file. 
     * @param name API Name  (required)
     * @param version Version of the API  (required)
     * @param providerName Provider name of the API  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Status on export  (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> exportApiGetWithHttpInfo(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        com.squareup.okhttp.Call call = exportApiGetValidateBeforeCall(name, version, providerName, format, preserveStatus, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export an API (asynchronously)
     * This operation can be used to export the details of a particular API as a zip file. 
     * @param name API Name  (required)
     * @param version Version of the API  (required)
     * @param providerName Provider name of the API  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Status on export  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call exportApiGetAsync(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = exportApiGetValidateBeforeCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for importApiPost
     * @param file Zip archive consisting on exported api configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API. This is the user choice to keep or replace the API provider.  (optional)
     * @param overwrite Whether to update the API or not. This is used when updating already existing APIs.  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call importApiPostCall(File file, Boolean preserveProvider, Boolean overwrite, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/import/api";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveProvider != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("preserveProvider", preserveProvider));
        if (overwrite != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("overwrite", overwrite));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call importApiPostValidateBeforeCall(File file, Boolean preserveProvider, Boolean overwrite, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApiPost(Async)");
        }
        

        com.squareup.okhttp.Call call = importApiPostCall(file, preserveProvider, overwrite, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Import an API
     * This operation can be used to import an API. 
     * @param file Zip archive consisting on exported api configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API. This is the user choice to keep or replace the API provider.  (optional)
     * @param overwrite Whether to update the API or not. This is used when updating already existing APIs.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void importApiPost(File file, Boolean preserveProvider, Boolean overwrite) throws ApiException {
        importApiPostWithHttpInfo(file, preserveProvider, overwrite);
    }

    /**
     * Import an API
     * This operation can be used to import an API. 
     * @param file Zip archive consisting on exported api configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API. This is the user choice to keep or replace the API provider.  (optional)
     * @param overwrite Whether to update the API or not. This is used when updating already existing APIs.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> importApiPostWithHttpInfo(File file, Boolean preserveProvider, Boolean overwrite) throws ApiException {
        com.squareup.okhttp.Call call = importApiPostValidateBeforeCall(file, preserveProvider, overwrite, null, null);
        return apiClient.execute(call);
    }

    /**
     * Import an API (asynchronously)
     * This operation can be used to import an API. 
     * @param file Zip archive consisting on exported api configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API. This is the user choice to keep or replace the API provider.  (optional)
     * @param overwrite Whether to update the API or not. This is used when updating already existing APIs.  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call importApiPostAsync(File file, Boolean preserveProvider, Boolean overwrite, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = importApiPostValidateBeforeCall(file, preserveProvider, overwrite, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
