/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api;

import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.admin.api.dto.ErrorDTO;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiProductIndividualApi {
    private ApiClient apiClient;

    public ApiProductIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiProductIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for exportApiProductGet
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call exportApiProductGetCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/export/api-product";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (version != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
        if (providerName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("providerName", providerName));
        if (format != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("format", format));
        if (preserveStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("preserveStatus", preserveStatus));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/zip"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call exportApiProductGetValidateBeforeCall(String name, String version, String providerName, String format, Boolean preserveStatus, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling exportApiProductGet(Async)");
        }
        
        // verify the required parameter 'version' is set
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling exportApiProductGet(Async)");
        }
        

        com.squareup.okhttp.Call call = exportApiProductGetCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export an API Product
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File exportApiProductGet(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        ApiResponse<File> resp = exportApiProductGetWithHttpInfo(name, version, providerName, format, preserveStatus);
        return resp.getData();
    }

    /**
     * Export an API Product
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> exportApiProductGetWithHttpInfo(String name, String version, String providerName, String format, Boolean preserveStatus) throws ApiException {
        com.squareup.okhttp.Call call = exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export an API Product (asynchronously)
     * This operation can be used to export the details of a particular API Product as a zip file. 
     * @param name API Product Name  (required)
     * @param version Version of the API Product  (required)
     * @param providerName Provider name of the API Product  (optional)
     * @param format Format of output documents. Can be YAML or JSON.  (optional)
     * @param preserveStatus Preserve API Product Status on export  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call exportApiProductGetAsync(String name, String version, String providerName, String format, Boolean preserveStatus, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = exportApiProductGetValidateBeforeCall(name, version, providerName, format, preserveStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for importApiProductPost
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call importApiProductPostCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/import/api-product";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveProvider != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("preserveProvider", preserveProvider));
        if (importAPIs != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("importAPIs", importAPIs));
        if (overwriteAPIProduct != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("overwriteAPIProduct", overwriteAPIProduct));
        if (overwriteAPIs != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("overwriteAPIs", overwriteAPIs));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call importApiProductPostValidateBeforeCall(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApiProductPost(Async)");
        }
        

        com.squareup.okhttp.Call call = importApiProductPostCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Import an API Product
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void importApiProductPost(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        importApiProductPostWithHttpInfo(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs);
    }

    /**
     * Import an API Product
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> importApiProductPostWithHttpInfo(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs) throws ApiException {
        com.squareup.okhttp.Call call = importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, null, null);
        return apiClient.execute(call);
    }

    /**
     * Import an API Product (asynchronously)
     * This operation can be used to import an API Product. 
     * @param file Zip archive consisting on exported API Product configuration  (required)
     * @param preserveProvider Preserve Original Provider of the API Product. This is the user choice to keep or replace the API Product provider.  (optional)
     * @param importAPIs Whether to import the dependent APIs or not.  (optional)
     * @param overwriteAPIProduct Whether to update the API Product or not. This is used when updating already existing API Products.  (optional)
     * @param overwriteAPIs Whether to update the dependent APIs or not. This is used when updating already existing dependent APIs of an API Product.  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call importApiProductPostAsync(File file, Boolean preserveProvider, Boolean importAPIs, Boolean overwriteAPIProduct, Boolean overwriteAPIs, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = importApiProductPostValidateBeforeCall(file, preserveProvider, importAPIs, overwriteAPIProduct, overwriteAPIs, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
