/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api;

import org.wso2.am.integration.clients.admin.ApiCallback;
import org.wso2.am.integration.clients.admin.ApiClient;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.Configuration;
import org.wso2.am.integration.clients.admin.Pair;
import org.wso2.am.integration.clients.admin.ProgressRequestBody;
import org.wso2.am.integration.clients.admin.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.wso2.am.integration.clients.admin.api.dto.APIInfoListDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.ErrorDTO;
import java.io.File;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationIndividualApi {
    private ApiClient apiClient;

    public ApplicationIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for exportApplicationsGet
     * @param appName Application Name  (required)
     * @param appOwner Owner of the Application  (required)
     * @param withKeys Export application keys  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call exportApplicationsGetCall(String appName, String appOwner, Boolean withKeys, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/export/applications";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (appName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("appName", appName));
        if (appOwner != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("appOwner", appOwner));
        if (withKeys != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("withKeys", withKeys));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/zip"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call exportApplicationsGetValidateBeforeCall(String appName, String appOwner, Boolean withKeys, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'appName' is set
        if (appName == null) {
            throw new ApiException("Missing the required parameter 'appName' when calling exportApplicationsGet(Async)");
        }
        
        // verify the required parameter 'appOwner' is set
        if (appOwner == null) {
            throw new ApiException("Missing the required parameter 'appOwner' when calling exportApplicationsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = exportApplicationsGetCall(appName, appOwner, withKeys, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export an Application
     * This operation can be used to export the details of a particular Application as a zip file. 
     * @param appName Application Name  (required)
     * @param appOwner Owner of the Application  (required)
     * @param withKeys Export application keys  (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File exportApplicationsGet(String appName, String appOwner, Boolean withKeys) throws ApiException {
        ApiResponse<File> resp = exportApplicationsGetWithHttpInfo(appName, appOwner, withKeys);
        return resp.getData();
    }

    /**
     * Export an Application
     * This operation can be used to export the details of a particular Application as a zip file. 
     * @param appName Application Name  (required)
     * @param appOwner Owner of the Application  (required)
     * @param withKeys Export application keys  (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> exportApplicationsGetWithHttpInfo(String appName, String appOwner, Boolean withKeys) throws ApiException {
        com.squareup.okhttp.Call call = exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export an Application (asynchronously)
     * This operation can be used to export the details of a particular Application as a zip file. 
     * @param appName Application Name  (required)
     * @param appOwner Owner of the Application  (required)
     * @param withKeys Export application keys  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call exportApplicationsGetAsync(String appName, String appOwner, Boolean withKeys, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = exportApplicationsGetValidateBeforeCall(appName, appOwner, withKeys, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for importApplicationsPost
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call importApplicationsPostCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/import/applications";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (preserveOwner != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("preserveOwner", preserveOwner));
        if (skipSubscriptions != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skipSubscriptions", skipSubscriptions));
        if (appOwner != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("appOwner", appOwner));
        if (skipApplicationKeys != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("skipApplicationKeys", skipApplicationKeys));
        if (update != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("update", update));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "OAuth2Security" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call importApplicationsPostValidateBeforeCall(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling importApplicationsPost(Async)");
        }
        

        com.squareup.okhttp.Call call = importApplicationsPostCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Import an Application
     * This operation can be used to import an Application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @return ApplicationInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApplicationInfoDTO importApplicationsPost(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        ApiResponse<ApplicationInfoDTO> resp = importApplicationsPostWithHttpInfo(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update);
        return resp.getData();
    }

    /**
     * Import an Application
     * This operation can be used to import an Application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @return ApiResponse&lt;ApplicationInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApplicationInfoDTO> importApplicationsPostWithHttpInfo(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update) throws ApiException {
        com.squareup.okhttp.Call call = importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, null, null);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Import an Application (asynchronously)
     * This operation can be used to import an Application. 
     * @param file Zip archive consisting of exported Application Configuration.  (required)
     * @param preserveOwner Preserve Original Creator of the Application  (optional)
     * @param skipSubscriptions Skip importing Subscriptions of the Application  (optional)
     * @param appOwner Expected Owner of the Application in the Import Environment  (optional)
     * @param skipApplicationKeys Skip importing Keys of the Application  (optional)
     * @param update Update if application exists  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call importApplicationsPostAsync(File file, Boolean preserveOwner, Boolean skipSubscriptions, String appOwner, Boolean skipApplicationKeys, Boolean update, final ApiCallback<ApplicationInfoDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = importApplicationsPostValidateBeforeCall(file, preserveOwner, skipSubscriptions, appOwner, skipApplicationKeys, update, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApplicationInfoDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
