/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Blocking Conditions
 */
@ApiModel(description = "Blocking Conditions")

public class BlockingConditionDTO {
  @SerializedName("conditionId")
  private String conditionId = null;

  @SerializedName("conditionType")
  private String conditionType = null;

  @SerializedName("conditionValue")
  private Object conditionValue = null;

  @SerializedName("conditionStatus")
  private Boolean conditionStatus = null;

  public BlockingConditionDTO conditionId(String conditionId) {
    this.conditionId = conditionId;
    return this;
  }

   /**
   * Id of the blocking condition
   * @return conditionId
  **/
  @ApiModelProperty(example = "b513eb68-69e8-4c32-92cf-852c101363cf", value = "Id of the blocking condition")
  public String getConditionId() {
    return conditionId;
  }

  public void setConditionId(String conditionId) {
    this.conditionId = conditionId;
  }

  public BlockingConditionDTO conditionType(String conditionType) {
    this.conditionType = conditionType;
    return this;
  }

   /**
   * Type of the blocking condition
   * @return conditionType
  **/
  @ApiModelProperty(example = "IP", required = true, value = "Type of the blocking condition")
  public String getConditionType() {
    return conditionType;
  }

  public void setConditionType(String conditionType) {
    this.conditionType = conditionType;
  }

  public BlockingConditionDTO conditionValue(Object conditionValue) {
    this.conditionValue = conditionValue;
    return this;
  }

   /**
   * Value of the blocking condition
   * @return conditionValue
  **/
  @ApiModelProperty(example = "\"{\\\"fixedIp\\\":\\\"192.168.1.1\\\":\\\"invert\\\":false}\"", required = true, value = "Value of the blocking condition")
  public Object getConditionValue() {
    return conditionValue;
  }

  public void setConditionValue(Object conditionValue) {
    this.conditionValue = conditionValue;
  }

  public BlockingConditionDTO conditionStatus(Boolean conditionStatus) {
    this.conditionStatus = conditionStatus;
    return this;
  }

   /**
   * Status of the blocking condition
   * @return conditionStatus
  **/
  @ApiModelProperty(example = "true", value = "Status of the blocking condition")
  public Boolean isConditionStatus() {
    return conditionStatus;
  }

  public void setConditionStatus(Boolean conditionStatus) {
    this.conditionStatus = conditionStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BlockingConditionDTO blockingCondition = (BlockingConditionDTO) o;
    return Objects.equals(this.conditionId, blockingCondition.conditionId) &&
        Objects.equals(this.conditionType, blockingCondition.conditionType) &&
        Objects.equals(this.conditionValue, blockingCondition.conditionValue) &&
        Objects.equals(this.conditionStatus, blockingCondition.conditionStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditionId, conditionType, conditionValue, conditionStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BlockingConditionDTO {\n");
    
    sb.append("    conditionId: ").append(toIndentedString(conditionId)).append("\n");
    sb.append("    conditionType: ").append(toIndentedString(conditionType)).append("\n");
    sb.append("    conditionValue: ").append(toIndentedString(conditionValue)).append("\n");
    sb.append("    conditionStatus: ").append(toIndentedString(conditionStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

