/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * GraphQLQueryDTO
 */

public class GraphQLQueryDTO {
  @SerializedName("graphQLMaxComplexity")
  private Integer graphQLMaxComplexity = null;

  @SerializedName("graphQLMaxDepth")
  private Integer graphQLMaxDepth = null;

  public GraphQLQueryDTO graphQLMaxComplexity(Integer graphQLMaxComplexity) {
    this.graphQLMaxComplexity = graphQLMaxComplexity;
    return this;
  }

   /**
   * Maximum Complexity of the GraphQL query
   * @return graphQLMaxComplexity
  **/
  @ApiModelProperty(example = "400", value = "Maximum Complexity of the GraphQL query")
  public Integer getGraphQLMaxComplexity() {
    return graphQLMaxComplexity;
  }

  public void setGraphQLMaxComplexity(Integer graphQLMaxComplexity) {
    this.graphQLMaxComplexity = graphQLMaxComplexity;
  }

  public GraphQLQueryDTO graphQLMaxDepth(Integer graphQLMaxDepth) {
    this.graphQLMaxDepth = graphQLMaxDepth;
    return this;
  }

   /**
   * Maximum Depth of the GraphQL query
   * @return graphQLMaxDepth
  **/
  @ApiModelProperty(example = "10", value = "Maximum Depth of the GraphQL query")
  public Integer getGraphQLMaxDepth() {
    return graphQLMaxDepth;
  }

  public void setGraphQLMaxDepth(Integer graphQLMaxDepth) {
    this.graphQLMaxDepth = graphQLMaxDepth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphQLQueryDTO graphQLQuery = (GraphQLQueryDTO) o;
    return Objects.equals(this.graphQLMaxComplexity, graphQLQuery.graphQLMaxComplexity) &&
        Objects.equals(this.graphQLMaxDepth, graphQLQuery.graphQLMaxDepth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(graphQLMaxComplexity, graphQLMaxDepth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphQLQueryDTO {\n");
    
    sb.append("    graphQLMaxComplexity: ").append(toIndentedString(graphQLMaxComplexity)).append("\n");
    sb.append("    graphQLMaxDepth: ").append(toIndentedString(graphQLMaxDepth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

