/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * IPConditionDTO
 */

public class IPConditionDTO {
  /**
   * Type of the IP condition. Allowed values are \&quot;IPRANGE\&quot; and \&quot;IPSPECIFIC\&quot;
   */
  @JsonAdapter(IpConditionTypeEnum.Adapter.class)
  public enum IpConditionTypeEnum {
    IPRANGE("IPRANGE"),
    
    IPSPECIFIC("IPSPECIFIC");

    private String value;

    IpConditionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static IpConditionTypeEnum fromValue(String text) {
      for (IpConditionTypeEnum b : IpConditionTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<IpConditionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final IpConditionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public IpConditionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return IpConditionTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("ipConditionType")
  private IpConditionTypeEnum ipConditionType = null;

  @SerializedName("specificIP")
  private String specificIP = null;

  @SerializedName("startingIP")
  private String startingIP = null;

  @SerializedName("endingIP")
  private String endingIP = null;

  public IPConditionDTO ipConditionType(IpConditionTypeEnum ipConditionType) {
    this.ipConditionType = ipConditionType;
    return this;
  }

   /**
   * Type of the IP condition. Allowed values are \&quot;IPRANGE\&quot; and \&quot;IPSPECIFIC\&quot;
   * @return ipConditionType
  **/
  @ApiModelProperty(value = "Type of the IP condition. Allowed values are \"IPRANGE\" and \"IPSPECIFIC\"")
  public IpConditionTypeEnum getIpConditionType() {
    return ipConditionType;
  }

  public void setIpConditionType(IpConditionTypeEnum ipConditionType) {
    this.ipConditionType = ipConditionType;
  }

  public IPConditionDTO specificIP(String specificIP) {
    this.specificIP = specificIP;
    return this;
  }

   /**
   * Specific IP when \&quot;IPSPECIFIC\&quot; is used as the ipConditionType
   * @return specificIP
  **/
  @ApiModelProperty(required = true, value = "Specific IP when \"IPSPECIFIC\" is used as the ipConditionType")
  public String getSpecificIP() {
    return specificIP;
  }

  public void setSpecificIP(String specificIP) {
    this.specificIP = specificIP;
  }

  public IPConditionDTO startingIP(String startingIP) {
    this.startingIP = startingIP;
    return this;
  }

   /**
   * Staring IP when \&quot;IPRANGE\&quot; is used as the ipConditionType
   * @return startingIP
  **/
  @ApiModelProperty(value = "Staring IP when \"IPRANGE\" is used as the ipConditionType")
  public String getStartingIP() {
    return startingIP;
  }

  public void setStartingIP(String startingIP) {
    this.startingIP = startingIP;
  }

  public IPConditionDTO endingIP(String endingIP) {
    this.endingIP = endingIP;
    return this;
  }

   /**
   * Ending IP when \&quot;IPRANGE\&quot; is used as the ipConditionType
   * @return endingIP
  **/
  @ApiModelProperty(value = "Ending IP when \"IPRANGE\" is used as the ipConditionType")
  public String getEndingIP() {
    return endingIP;
  }

  public void setEndingIP(String endingIP) {
    this.endingIP = endingIP;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IPConditionDTO ipCondition = (IPConditionDTO) o;
    return Objects.equals(this.ipConditionType, ipCondition.ipConditionType) &&
        Objects.equals(this.specificIP, ipCondition.specificIP) &&
        Objects.equals(this.startingIP, ipCondition.startingIP) &&
        Objects.equals(this.endingIP, ipCondition.endingIP);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ipConditionType, specificIP, startingIP, endingIP);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IPConditionDTO {\n");
    
    sb.append("    ipConditionType: ").append(toIndentedString(ipConditionType)).append("\n");
    sb.append("    specificIP: ").append(toIndentedString(specificIP)).append("\n");
    sb.append("    startingIP: ").append(toIndentedString(startingIP)).append("\n");
    sb.append("    endingIP: ").append(toIndentedString(endingIP)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

