/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * ScopeDTO
 */

public class ScopeDTO {
  @SerializedName("tag")
  private String tag = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("roles")
  private Object roles = null;

  public ScopeDTO tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Portal name. 
   * @return tag
  **/
  @ApiModelProperty(example = "publisher", value = "Portal name. ")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public ScopeDTO name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Scope name. 
   * @return name
  **/
  @ApiModelProperty(example = "apim:api_publish", value = "Scope name. ")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ScopeDTO description(String description) {
    this.description = description;
    return this;
  }

   /**
   * About scope. 
   * @return description
  **/
  @ApiModelProperty(example = "Publish API", value = "About scope. ")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ScopeDTO roles(Object roles) {
    this.roles = roles;
    return this;
  }

   /**
   * Roles for the particular scope. 
   * @return roles
  **/
  @ApiModelProperty(example = "", value = "Roles for the particular scope. ")
  public Object getRoles() {
    return roles;
  }

  public void setRoles(Object roles) {
    this.roles = roles;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScopeDTO scope = (ScopeDTO) o;
    return Objects.equals(this.tag, scope.tag) &&
        Objects.equals(this.name, scope.name) &&
        Objects.equals(this.description, scope.description) &&
        Objects.equals(this.roles, scope.roles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tag, name, description, roles);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScopeDTO {\n");
    
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

