/*
 * WSO2 API Manager - Admin
 * This document specifies a **RESTful API** for WSO2 **API Manager** - Admin Portal. Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.5.176/components/apimgt/org.wso2.carbon.apimgt.rest.api.admin/src/main/resources/admin-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.2
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.am.integration.clients.admin.api.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.wso2.am.integration.clients.admin.api.dto.SettingsKeyManagerConfigurationDTO;

/**
 * SettingsDTO
 */

public class SettingsDTO {
  @SerializedName("scopes")
  private List<String> scopes = null;

  @SerializedName("keyManagerConfiguration")
  private List<SettingsKeyManagerConfigurationDTO> keyManagerConfiguration = null;

  @SerializedName("analyticsEnabled")
  private Boolean analyticsEnabled = null;

  public SettingsDTO scopes(List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

  public SettingsDTO addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Get scopes
   * @return scopes
  **/
  @ApiModelProperty(value = "")
  public List<String> getScopes() {
    return scopes;
  }

  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }

  public SettingsDTO keyManagerConfiguration(List<SettingsKeyManagerConfigurationDTO> keyManagerConfiguration) {
    this.keyManagerConfiguration = keyManagerConfiguration;
    return this;
  }

  public SettingsDTO addKeyManagerConfigurationItem(SettingsKeyManagerConfigurationDTO keyManagerConfigurationItem) {
    if (this.keyManagerConfiguration == null) {
      this.keyManagerConfiguration = new ArrayList<>();
    }
    this.keyManagerConfiguration.add(keyManagerConfigurationItem);
    return this;
  }

   /**
   * Get keyManagerConfiguration
   * @return keyManagerConfiguration
  **/
  @ApiModelProperty(value = "")
  public List<SettingsKeyManagerConfigurationDTO> getKeyManagerConfiguration() {
    return keyManagerConfiguration;
  }

  public void setKeyManagerConfiguration(List<SettingsKeyManagerConfigurationDTO> keyManagerConfiguration) {
    this.keyManagerConfiguration = keyManagerConfiguration;
  }

  public SettingsDTO analyticsEnabled(Boolean analyticsEnabled) {
    this.analyticsEnabled = analyticsEnabled;
    return this;
  }

   /**
   * To determine whether analytics is enabled or not
   * @return analyticsEnabled
  **/
  @ApiModelProperty(example = "false", value = "To determine whether analytics is enabled or not")
  public Boolean isAnalyticsEnabled() {
    return analyticsEnabled;
  }

  public void setAnalyticsEnabled(Boolean analyticsEnabled) {
    this.analyticsEnabled = analyticsEnabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SettingsDTO settings = (SettingsDTO) o;
    return Objects.equals(this.scopes, settings.scopes) &&
        Objects.equals(this.keyManagerConfiguration, settings.keyManagerConfiguration) &&
        Objects.equals(this.analyticsEnabled, settings.analyticsEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scopes, keyManagerConfiguration, analyticsEnabled);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SettingsDTO {\n");
    
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("    keyManagerConfiguration: ").append(toIndentedString(keyManagerConfiguration)).append("\n");
    sb.append("    analyticsEnabled: ").append(toIndentedString(analyticsEnabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

